// RUN: %clang_analyze_cc1 -triple x86_64-apple-darwin10 -analyzer-checker=core,debug.ExprInspection %s -std=c++11 -verify

void clang_analyzer_eval(bool);

void testAddressof(int x) {
  clang_analyzer_eval(&x == __builtin_addressof(x)); // expected-warning{{TRUE}}
}

void testSize() {
  struct {
    int x;
    int y;
    char z;
  } object;
  clang_analyzer_eval(__builtin_object_size(&object.y, 0) == sizeof(object) - sizeof(int)); // expected-warning{{TRUE}}

  // Clang can't actually evaluate these builtin "calls", but importantly they don't actually evaluate the argument expression either.
  int i = 0;
  char buf[10];
  clang_analyzer_eval(__builtin_object_size(&buf[i++], 0) == sizeof(buf)); // expected-warning{{FALSE}}
  clang_analyzer_eval(__builtin_object_size(&buf[++i], 0) == sizeof(buf) - 1); // expected-warning{{FALSE}}

  clang_analyzer_eval(i == 0); // expected-warning{{TRUE}}
}

void test_assume_aligned_1(char *p) {
  char *q;

  q = (char*) __builtin_assume_aligned(p, 16);
  clang_analyzer_eval(p == q); // expected-warning{{TRUE}}
}

void test_assume_aligned_2(char *p) {
  char *q;

  q = (char*) __builtin_assume_aligned(p, 16, 8);
  clang_analyzer_eval(p == q); // expected-warning{{TRUE}}
}

void test_assume_aligned_3(char *p) {
  void *q;

  q = __builtin_assume_aligned(p, 16, 8);
  clang_analyzer_eval(p == q); // expected-warning{{TRUE}}
}

void test_assume_aligned_4(char *p) {
  char *q;

  q = (char*) __builtin_assume_aligned(p + 1, 16);
  clang_analyzer_eval(p == q); // expected-warning{{FALSE}}
}
