//= LanaiInstPrinter.h - Convert Lanai MCInst to asm syntax -------*- C++ -*--//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This class prints a Lanai MCInst to a .s file.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_LANAI_INSTPRINTER_LANAIINSTPRINTER_H
#define LLVM_LIB_TARGET_LANAI_INSTPRINTER_LANAIINSTPRINTER_H

#include "llvm/MC/MCInstPrinter.h"

namespace llvm {
class MCOperand;

class LanaiInstPrinter : public MCInstPrinter {
public:
  LanaiInstPrinter(const MCAsmInfo &MAI, const MCInstrInfo &MII,
                   const MCRegisterInfo &MRI)
      : MCInstPrinter(MAI, MII, MRI) {}

  void printInst(const MCInst *MI, raw_ostream &O, StringRef Annot,
                 const MCSubtargetInfo &STI) override;
  void printOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O,
                    const char *Modifier = 0);
  void printMemRiOperand(const MCInst *MI, int OpNo, raw_ostream &O,
                         const char *Modifier = 0);
  void printMemRrOperand(const MCInst *MI, int OpNo, raw_ostream &O,
                         const char *Modifier = 0);
  void printMemSplsOperand(const MCInst *MI, int OpNo, raw_ostream &O,
                           const char *Modifier = 0);
  void printCCOperand(const MCInst *MI, int OpNo, raw_ostream &O);
  void printAluOperand(const MCInst *MI, int OpNo, raw_ostream &O);
  void printHi16ImmOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
  void printHi16AndImmOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
  void printLo16AndImmOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
  void printMemImmOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);

  // Autogenerated by tblgen.
  void printInstruction(const MCInst *MI, raw_ostream &O);
  bool printAliasInstr(const MCInst *MI, raw_ostream &OS);
  void printCustomAliasOperand(const MCInst *MI, unsigned OpIdx,
                               unsigned PrintMethodIdx, raw_ostream &O);
  static const char *getRegisterName(unsigned RegNo);
  void printRegName(raw_ostream &OS, unsigned RegNo) const override;

private:
  bool printAlias(const MCInst *MI, raw_ostream &Ostream);
  bool printInst(const MCInst *MI, raw_ostream &Ostream, StringRef Alias,
                 unsigned OpNo0, unsigned OpnNo1);
  bool printMemoryLoadIncrement(const MCInst *MI, raw_ostream &Ostream,
                                StringRef Opcode, int AddOffset);
  bool printMemoryStoreIncrement(const MCInst *MI, raw_ostream &Ostream,
                                 StringRef Opcode, int AddOffset);
};
} // namespace llvm

#endif // LLVM_LIB_TARGET_LANAI_INSTPRINTER_LANAIINSTPRINTER_H
