//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <algorithm>

// template<Iterator Iter1, Iterator Iter2> 
//   requires HasSwap<Iter1::reference, Iter2::reference> 
//   void
//   iter_swap(Iter1 a, Iter2 b);

#include <algorithm>
#include <cassert>

int main()
{
    int i = 1;
    int j = 2;
    std::iter_swap(&i, &j);
    assert(i == 2);
    assert(j == 1);
}
