//=====-- MipsSubtarget.h - Define Subtarget for the Mips -----*- C++ -*--====//
//
//                     The LLVM Compiler Infrastructure
//
// This file was developed by Bruno Cardoso Lopes and is distributed under the 
// University of Illinois Open Source License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file declares the Mips specific subclass of TargetSubtarget.
//
//===----------------------------------------------------------------------===//

#ifndef MIPSSUBTARGET_H
#define MIPSSUBTARGET_H

#include "llvm/Target/TargetSubtarget.h"
#include "llvm/Target/TargetMachine.h"

#include <string>

namespace llvm {
class Module;

class MipsSubtarget : public TargetSubtarget {

protected:

  bool IsMipsIII;
  InstrItineraryData InstrItins;

public:
  /// This constructor initializes the data members to match that
  /// of the specified module.
  ///
  MipsSubtarget(const TargetMachine &TM, const Module &M, 
                const std::string &FS);
  
  /// ParseSubtargetFeatures - Parses features string setting specified 
  /// subtarget options.  Definition of function is auto generated by tblgen.
  void ParseSubtargetFeatures(const std::string &FS, const std::string &CPU);

  /// isMipsIII - Return true if the selected CPU supports MipsIII ISA
  /// support. 
  bool isMipsIII() const { return IsMipsIII; }
};
} // End llvm namespace

#endif
