; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX --check-prefix=X32-AVX1
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx2 | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX --check-prefix=X32-AVX2
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512F
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512BW
; RUN: llc < %s -mtriple=i686-apple-darwin -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X32 --check-prefix=X32-AVX512 --check-prefix=X32-AVX512DQ
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX --check-prefix=X64-AVX1
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx2 | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX --check-prefix=X64-AVX2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512F
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512BW
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512 --check-prefix=X64-AVX512DQ

;
; Subvector Load + Broadcast
;

define <4 x double> @test_broadcast_2f64_4f64(<2 x double> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_2f64_4f64:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2f64_4f64:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2f64_4f64:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2f64_4f64:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2f64_4f64:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2f64_4f64:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2f64_4f64:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2f64_4f64:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x double>, <2 x double> *%p
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x double> %2
}

define <8 x double> @test_broadcast_2f64_8f64(<2 x double> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_2f64_8f64:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2f64_8f64:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2f64_8f64:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2f64_8f64:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 = mem[0,1,0,1,0,1,0,1]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2f64_8f64:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2f64_8f64:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2f64_8f64:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2f64_8f64:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 = mem[0,1,0,1,0,1,0,1]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x double>, <2 x double> *%p
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x double> %2
}

define <8 x double> @test_broadcast_4f64_8f64(<4 x double> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4f64_8f64:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f64_8f64:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f64_8f64:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f64_8f64:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x double>, <4 x double> *%p
 %2 = shufflevector <4 x double> %1, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x double> %2
}

define <4 x i64> @test_broadcast_2i64_4i64(<2 x i64> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_2i64_4i64:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2i64_4i64:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2i64_4i64:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2i64_4i64:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti64x2 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2i64_4i64:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2i64_4i64:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2i64_4i64:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2i64_4i64:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcasti64x2 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64> *%p
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x i64> %2
}

define <8 x i64> @test_broadcast_2i64_8i64(<2 x i64> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_2i64_8i64:
; X32-AVX1:       ## BB#0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_2i64_8i64:
; X32-AVX2:       ## BB#0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2i64_8i64:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2i64_8i64:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2i64_8i64:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti64x2 {{.*#+}} zmm0 = mem[0,1,0,1,0,1,0,1]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_2i64_8i64:
; X64-AVX1:       ## BB#0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_2i64_8i64:
; X64-AVX2:       ## BB#0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2i64_8i64:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2i64_8i64:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2i64_8i64:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcasti64x2 {{.*#+}} zmm0 = mem[0,1,0,1,0,1,0,1]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64> *%p
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
 ret <8 x i64> %2
}

define <8 x i64> @test_broadcast_4i64_8i64(<4 x i64> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4i64_8i64:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i64_8i64:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i64_8i64:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i64_8i64:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i64>, <4 x i64> *%p
 %2 = shufflevector <4 x i64> %1, <4 x i64> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i64> %2
}

define <8 x float> @test_broadcast_4f32_8f32(<4 x float> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4f32_8f32:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f32_8f32:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f32_8f32:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f32_8f32:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x float>, <4 x float> *%p
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x float> %2
}

define <16 x float> @test_broadcast_4f32_16f32(<4 x float> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4f32_16f32:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f32_16f32:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f32_16f32:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f32_16f32:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x float>, <4 x float> *%p
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x float> %2
}

define <16 x float> @test_broadcast_8f32_16f32(<8 x float> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8f32_16f32:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_8f32_16f32:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_8f32_16f32:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_8f32_16f32:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8f32_16f32:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_8f32_16f32:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_8f32_16f32:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_8f32_16f32:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <8 x float>, <8 x float> *%p
 %2 = shufflevector <8 x float> %1, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x float> %2
}

define <8 x i32> @test_broadcast_4i32_8i32(<4 x i32> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_4i32_8i32:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i32_8i32:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_8i32:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i32_8i32:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32> *%p
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i32> %2
}

define <16 x i32> @test_broadcast_4i32_16i32(<4 x i32> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_4i32_16i32:
; X32-AVX1:       ## BB#0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_4i32_16i32:
; X32-AVX2:       ## BB#0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i32_16i32:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_4i32_16i32:
; X64-AVX1:       ## BB#0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_4i32_16i32:
; X64-AVX2:       ## BB#0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i32_16i32:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32> *%p
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <16 x i32> %2
}

define <16 x i32> @test_broadcast_8i32_16i32(<8 x i32> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8i32_16i32:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_8i32_16i32:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_8i32_16i32:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_8i32_16i32:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti32x8 {{.*#+}} zmm0 = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8i32_16i32:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_8i32_16i32:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_8i32_16i32:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_8i32_16i32:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcasti32x8 {{.*#+}} zmm0 = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; X64-AVX512DQ-NEXT:    retq
 %1 = load <8 x i32>, <8 x i32> *%p
 %2 = shufflevector <8 x i32> %1, <8 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i32> %2
}

define <16 x i16> @test_broadcast_8i16_16i16(<8 x i16> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_8i16_16i16:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_8i16_16i16:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8i16_16i16:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_8i16_16i16:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i16> %2
}

define <32 x i16> @test_broadcast_8i16_32i16(<8 x i16> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_8i16_32i16:
; X32-AVX1:       ## BB#0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_8i16_32i16:
; X32-AVX2:       ## BB#0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    vmovdqa64 %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_8i16_32i16:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_8i16_32i16:
; X64-AVX1:       ## BB#0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_8i16_32i16:
; X64-AVX2:       ## BB#0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    vmovdqa64 %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_8i16_32i16:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <32 x i16> %2
}

define <32 x i16> @test_broadcast_16i16_32i16(<16 x i16> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_16i16_32i16:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_16i16_32i16:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_16i16_32i16:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_16i16_32i16:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <16 x i16>, <16 x i16> *%p
 %2 = shufflevector <16 x i16> %1, <16 x i16> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i16> %2
}

define <32 x i8> @test_broadcast_16i8_32i8(<16 x i8> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_16i8_32i8:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_16i8_32i8:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_16i8_32i8:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_16i8_32i8:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i8> %2
}

define <64 x i8> @test_broadcast_16i8_64i8(<16 x i8> *%p) nounwind {
; X32-AVX1-LABEL: test_broadcast_16i8_64i8:
; X32-AVX1:       ## BB#0:
; X32-AVX1-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X32-AVX1-NEXT:    retl
;
; X32-AVX2-LABEL: test_broadcast_16i8_64i8:
; X32-AVX2:       ## BB#0:
; X32-AVX2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X32-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX2-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512F-NEXT:    vmovdqa64 %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_16i8_64i8:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX1-LABEL: test_broadcast_16i8_64i8:
; X64-AVX1:       ## BB#0:
; X64-AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX1-NEXT:    vmovdqa %ymm0, %ymm1
; X64-AVX1-NEXT:    retq
;
; X64-AVX2-LABEL: test_broadcast_16i8_64i8:
; X64-AVX2:       ## BB#0:
; X64-AVX2-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; X64-AVX2-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX2-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512F-NEXT:    vmovdqa64 %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_16i8_64i8:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} ymm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512DQ-NEXT:    vmovdqa64 %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <64 x i8> %2
}

define <64 x i8> @test_broadcast_32i8_64i8(<32 x i8> *%p) nounwind {
; X32-AVX-LABEL: test_broadcast_32i8_64i8:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_32i8_64i8:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    vmovaps (%eax), %ymm0
; X32-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_32i8_64i8:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512F-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_32i8_64i8:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; X64-AVX512DQ-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX512DQ-NEXT:    retq
 %1 = load <32 x i8>, <32 x i8> *%p
 %2 = shufflevector <32 x i8> %1, <32 x i8> undef, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
 ret <64 x i8> %2
}

;
; Subvector Load + Broadcast + Store
;

define <4 x double> @test_broadcast_2f64_4f64_reuse(<2 x double>* %p0, <2 x double>* %p1) {
; X32-AVX-LABEL: test_broadcast_2f64_4f64_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2f64_4f64_reuse:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512F-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX512F-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2f64_4f64_reuse:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX512BW-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2f64_4f64_reuse:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovapd (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vmovapd %xmm0, (%eax)
; X32-AVX512DQ-NEXT:    vinsertf64x2 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2f64_4f64_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2f64_4f64_reuse:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512F-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX512F-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2f64_4f64_reuse:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX512BW-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2f64_4f64_reuse:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovapd (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vmovapd %xmm0, (%rsi)
; X64-AVX512DQ-NEXT:    vinsertf64x2 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x double>, <2 x double>* %p0
 store <2 x double> %1, <2 x double>* %p1
 %2 = shufflevector <2 x double> %1, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x double> %2
}

define <4 x i64> @test_broadcast_2i64_4i64_reuse(<2 x i64>* %p0, <2 x i64>* %p1) {
; X32-AVX-LABEL: test_broadcast_2i64_4i64_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_2i64_4i64_reuse:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512F-NEXT:    vmovdqa64 %xmm0, (%eax)
; X32-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_2i64_4i64_reuse:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vmovdqa64 %xmm0, (%eax)
; X32-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_2i64_4i64_reuse:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vmovdqa64 %xmm0, (%eax)
; X32-AVX512DQ-NEXT:    vinserti64x2 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_2i64_4i64_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_2i64_4i64_reuse:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512F-NEXT:    vmovdqa64 %xmm0, (%rsi)
; X64-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_2i64_4i64_reuse:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vmovdqa64 %xmm0, (%rsi)
; X64-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_2i64_4i64_reuse:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vmovdqa64 %xmm0, (%rsi)
; X64-AVX512DQ-NEXT:    vinserti64x2 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
 %1 = load <2 x i64>, <2 x i64>* %p0
 store <2 x i64> %1, <2 x i64>* %p1
 %2 = shufflevector <2 x i64> %1, <2 x i64> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
 ret <4 x i64> %2
}

define <8 x float> @test_broadcast_4f32_8f32_reuse(<4 x float>* %p0, <4 x float>* %p1) {
; X32-AVX-LABEL: test_broadcast_4f32_8f32_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4f32_8f32_reuse:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX512-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX512-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4f32_8f32_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4f32_8f32_reuse:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX512-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX512-NEXT:    vinsertf32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    retq
 %1 = load <4 x float>, <4 x float>* %p0
 store <4 x float> %1, <4 x float>* %p1
 %2 = shufflevector <4 x float> %1, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x float> %2
}

define <8 x i32> @test_broadcast_4i32_8i32_reuse(<4 x i32>* %p0, <4 x i32>* %p1) {
; X32-AVX-LABEL: test_broadcast_4i32_8i32_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512-LABEL: test_broadcast_4i32_8i32_reuse:
; X32-AVX512:       ## BB#0:
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512-NEXT:    vmovdqa32 (%ecx), %xmm0
; X32-AVX512-NEXT:    vmovdqa32 %xmm0, (%eax)
; X32-AVX512-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_8i32_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512-LABEL: test_broadcast_4i32_8i32_reuse:
; X64-AVX512:       ## BB#0:
; X64-AVX512-NEXT:    vmovdqa32 (%rdi), %xmm0
; X64-AVX512-NEXT:    vmovdqa32 %xmm0, (%rsi)
; X64-AVX512-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512-NEXT:    retq
 %1 = load <4 x i32>, <4 x i32>* %p0
 store <4 x i32> %1, <4 x i32>* %p1
 %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
 ret <8 x i32> %2
}

define <16 x i16> @test_broadcast_8i16_16i16_reuse(<8 x i16> *%p0, <8 x i16> *%p1) nounwind {
; X32-AVX-LABEL: test_broadcast_8i16_16i16_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_8i16_16i16_reuse:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512F-NEXT:    vmovdqa32 %xmm0, (%eax)
; X32-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_8i16_16i16_reuse:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqu16 (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vmovdqu16 %xmm0, (%eax)
; X32-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_8i16_16i16_reuse:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vmovdqa32 %xmm0, (%eax)
; X32-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_8i16_16i16_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_8i16_16i16_reuse:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512F-NEXT:    vmovdqa32 %xmm0, (%rsi)
; X64-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_8i16_16i16_reuse:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovdqu16 (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vmovdqu16 %xmm0, (%rsi)
; X64-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_8i16_16i16_reuse:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vmovdqa32 %xmm0, (%rsi)
; X64-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
 %1 = load <8 x i16>, <8 x i16> *%p0
 store <8 x i16> %1, <8 x i16>* %p1
 %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
 ret <16 x i16> %2
}

define <32 x i8> @test_broadcast_16i8_32i8_reuse(<16 x i8> *%p0, <16 x i8> *%p1) nounwind {
; X32-AVX-LABEL: test_broadcast_16i8_32i8_reuse:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vmovaps %xmm0, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_16i8_32i8_reuse:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512F-NEXT:    vmovdqa32 %xmm0, (%eax)
; X32-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_16i8_32i8_reuse:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqu8 (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vmovdqu8 %xmm0, (%eax)
; X32-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_16i8_32i8_reuse:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vmovdqa32 %xmm0, (%eax)
; X32-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_16i8_32i8_reuse:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vmovaps %xmm0, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_16i8_32i8_reuse:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512F-NEXT:    vmovdqa32 %xmm0, (%rsi)
; X64-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_16i8_32i8_reuse:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovdqu8 (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vmovdqu8 %xmm0, (%rsi)
; X64-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_16i8_32i8_reuse:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vmovdqa32 %xmm0, (%rsi)
; X64-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
 %1 = load <16 x i8>, <16 x i8> *%p0
 store <16 x i8> %1, <16 x i8>* %p1
 %2 = shufflevector <16 x i8> %1, <16 x i8> undef, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
 ret <32 x i8> %2
}

;
; Subvector Load + Broadcast with Separate Store
;

define <8 x i32> @test_broadcast_4i32_8i32_chain(<4 x i32>* %p0, <4 x float>* %p1) {
; X32-AVX-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512F-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X32-AVX512F-NEXT:    vmovdqa32 %xmm1, (%eax)
; X32-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X32-AVX512BW-NEXT:    vmovdqa32 %xmm1, (%eax)
; X32-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_4i32_8i32_chain:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX512DQ-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512F-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X64-AVX512F-NEXT:    vmovdqa32 %xmm1, (%rsi)
; X64-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X64-AVX512BW-NEXT:    vmovdqa32 %xmm1, (%rsi)
; X64-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_4i32_8i32_chain:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %ymm0, %ymm0
; X64-AVX512DQ-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %p0
  store <4 x float> zeroinitializer, <4 x float>* %p1
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <8 x i32> %2
}

define <16 x i32> @test_broadcast_4i32_16i32_chain(<4 x i32>* %p0, <4 x float>* %p1) {
; X32-AVX-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX:       ## BB#0:
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX-NEXT:    vmovaps (%ecx), %xmm0
; X32-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X32-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X32-AVX-NEXT:    retl
;
; X32-AVX512F-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512F:       ## BB#0:
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512F-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512F-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512F-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X32-AVX512F-NEXT:    vmovdqa32 %xmm1, (%eax)
; X32-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X32-AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512F-NEXT:    retl
;
; X32-AVX512BW-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512BW:       ## BB#0:
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512BW-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512BW-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512BW-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X32-AVX512BW-NEXT:    vmovdqa32 %xmm1, (%eax)
; X32-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512BW-NEXT:    retl
;
; X32-AVX512DQ-LABEL: test_broadcast_4i32_16i32_chain:
; X32-AVX512DQ:       ## BB#0:
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-AVX512DQ-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-AVX512DQ-NEXT:    vmovdqa64 (%ecx), %xmm0
; X32-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X32-AVX512DQ-NEXT:    vmovaps %xmm1, (%eax)
; X32-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X32-AVX512DQ-NEXT:    vinserti32x8 $1, %ymm0, %zmm0, %zmm0
; X32-AVX512DQ-NEXT:    retl
;
; X64-AVX-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX:       ## BB#0:
; X64-AVX-NEXT:    vmovaps (%rdi), %xmm0
; X64-AVX-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; X64-AVX-NEXT:    vmovaps %ymm0, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512F-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512F:       ## BB#0:
; X64-AVX512F-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512F-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X64-AVX512F-NEXT:    vmovdqa32 %xmm1, (%rsi)
; X64-AVX512F-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X64-AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512F-NEXT:    retq
;
; X64-AVX512BW-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512BW:       ## BB#0:
; X64-AVX512BW-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512BW-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; X64-AVX512BW-NEXT:    vmovdqa32 %xmm1, (%rsi)
; X64-AVX512BW-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    vinserti64x4 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512BW-NEXT:    retq
;
; X64-AVX512DQ-LABEL: test_broadcast_4i32_16i32_chain:
; X64-AVX512DQ:       ## BB#0:
; X64-AVX512DQ-NEXT:    vmovdqa64 (%rdi), %xmm0
; X64-AVX512DQ-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; X64-AVX512DQ-NEXT:    vmovaps %xmm1, (%rsi)
; X64-AVX512DQ-NEXT:    vinserti32x4 $1, %xmm0, %zmm0, %zmm0
; X64-AVX512DQ-NEXT:    vinserti32x8 $1, %ymm0, %zmm0, %zmm0
; X64-AVX512DQ-NEXT:    retq
  %1 = load <4 x i32>, <4 x i32>* %p0
  store <4 x float> zeroinitializer, <4 x float>* %p1
  %2 = shufflevector <4 x i32> %1, <4 x i32> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <16 x i32> %2
}
