; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+f16c | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+f16c | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,-f16c | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512 --check-prefix=AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefix=ALL --check-prefix=AVX --check-prefix=AVX512 --check-prefix=AVX512VL

;
; Half to Float
;

define float @cvt_i16_to_f32(i16 %a0) nounwind {
; AVX1-LABEL: cvt_i16_to_f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl %di, %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_i16_to_f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl %di, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_i16_to_f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl %di, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_i16_to_f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl %di, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
  %1 = bitcast i16 %a0 to half
  %2 = fpext half %1 to float
  ret float %2
}

define <4 x float> @cvt_4i16_to_4f32(<4 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_4i16_to_4f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movq %rax, %rdx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrq $48, %rdx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    vmovd %esi, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4i16_to_4f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movq %rax, %rdx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrq $48, %rdx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vmovd %esi, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4i16_to_4f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movq %rax, %rdx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrq $48, %rdx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    vmovd %esi, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4i16_to_4f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movq %rax, %rdx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrq $48, %rdx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %esi, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = bitcast <4 x i16> %a0 to <4 x half>
  %2 = fpext <4 x half> %1 to <4 x float>
  ret <4 x float> %2
}

define <4 x float> @cvt_8i16_to_4f32(<8 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_8i16_to_4f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movq %rax, %rdx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrq $48, %rdx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    vmovd %esi, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8i16_to_4f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movq %rax, %rdx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrq $48, %rdx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vmovd %esi, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8i16_to_4f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movq %rax, %rdx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrq $48, %rdx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    vmovd %esi, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8i16_to_4f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movq %rax, %rdx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrq $48, %rdx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %esi, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = fpext <4 x half> %2 to <4 x float>
  ret <4 x float> %3
}

define <8 x float> @cvt_8i16_to_8f32(<8 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_8i16_to_8f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX1-NEXT:    movq %rdx, %r8
; AVX1-NEXT:    movq %rdx, %r10
; AVX1-NEXT:    movswl %dx, %r9d
; AVX1-NEXT:    # kill: %EDX<def> %EDX<kill> %RDX<kill>
; AVX1-NEXT:    shrl $16, %edx
; AVX1-NEXT:    shrq $32, %r8
; AVX1-NEXT:    shrq $48, %r10
; AVX1-NEXT:    vmovq %xmm0, %rdi
; AVX1-NEXT:    movq %rdi, %rax
; AVX1-NEXT:    movq %rdi, %rsi
; AVX1-NEXT:    movswl %di, %ecx
; AVX1-NEXT:    # kill: %EDI<def> %EDI<kill> %RDI<kill>
; AVX1-NEXT:    shrl $16, %edi
; AVX1-NEXT:    shrq $32, %rax
; AVX1-NEXT:    shrq $48, %rsi
; AVX1-NEXT:    movswl %si, %esi
; AVX1-NEXT:    vmovd %esi, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl %di, %eax
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    vmovd %ecx, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    movswl %r10w, %eax
; AVX1-NEXT:    vmovd %eax, %xmm4
; AVX1-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX1-NEXT:    movswl %r8w, %eax
; AVX1-NEXT:    vmovd %eax, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    movswl %dx, %eax
; AVX1-NEXT:    vmovd %eax, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    vmovd %r9d, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    vinsertps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8i16_to_8f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX2-NEXT:    movq %rdx, %r8
; AVX2-NEXT:    movq %rdx, %r10
; AVX2-NEXT:    movswl %dx, %r9d
; AVX2-NEXT:    # kill: %EDX<def> %EDX<kill> %RDX<kill>
; AVX2-NEXT:    shrl $16, %edx
; AVX2-NEXT:    shrq $32, %r8
; AVX2-NEXT:    shrq $48, %r10
; AVX2-NEXT:    vmovq %xmm0, %rdi
; AVX2-NEXT:    movq %rdi, %rax
; AVX2-NEXT:    movq %rdi, %rsi
; AVX2-NEXT:    movswl %di, %ecx
; AVX2-NEXT:    # kill: %EDI<def> %EDI<kill> %RDI<kill>
; AVX2-NEXT:    shrl $16, %edi
; AVX2-NEXT:    shrq $32, %rax
; AVX2-NEXT:    shrq $48, %rsi
; AVX2-NEXT:    movswl %si, %esi
; AVX2-NEXT:    vmovd %esi, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl %di, %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vmovd %ecx, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    movswl %r10w, %eax
; AVX2-NEXT:    vmovd %eax, %xmm4
; AVX2-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX2-NEXT:    movswl %r8w, %eax
; AVX2-NEXT:    vmovd %eax, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    movswl %dx, %eax
; AVX2-NEXT:    vmovd %eax, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    vmovd %r9d, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    vinsertps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8i16_to_8f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX512F-NEXT:    movq %rdx, %r8
; AVX512F-NEXT:    movq %rdx, %r9
; AVX512F-NEXT:    movswl %dx, %r10d
; AVX512F-NEXT:    # kill: %EDX<def> %EDX<kill> %RDX<kill>
; AVX512F-NEXT:    shrl $16, %edx
; AVX512F-NEXT:    shrq $32, %r8
; AVX512F-NEXT:    shrq $48, %r9
; AVX512F-NEXT:    vmovq %xmm0, %rdi
; AVX512F-NEXT:    movq %rdi, %rax
; AVX512F-NEXT:    movq %rdi, %rcx
; AVX512F-NEXT:    movswl %di, %esi
; AVX512F-NEXT:    # kill: %EDI<def> %EDI<kill> %RDI<kill>
; AVX512F-NEXT:    shrl $16, %edi
; AVX512F-NEXT:    shrq $32, %rax
; AVX512F-NEXT:    shrq $48, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl %di, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    vmovd %esi, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    movswl %r9w, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    movswl %r8w, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm5
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    movswl %dx, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm6
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    vmovd %r10d, %xmm7
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8i16_to_8f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX512VL-NEXT:    movq %rdx, %r8
; AVX512VL-NEXT:    movq %rdx, %r10
; AVX512VL-NEXT:    movswl %dx, %r9d
; AVX512VL-NEXT:    # kill: %EDX<def> %EDX<kill> %RDX<kill>
; AVX512VL-NEXT:    shrl $16, %edx
; AVX512VL-NEXT:    shrq $32, %r8
; AVX512VL-NEXT:    shrq $48, %r10
; AVX512VL-NEXT:    vmovq %xmm0, %rdi
; AVX512VL-NEXT:    movq %rdi, %rax
; AVX512VL-NEXT:    movq %rdi, %rsi
; AVX512VL-NEXT:    movswl %di, %ecx
; AVX512VL-NEXT:    # kill: %EDI<def> %EDI<kill> %RDI<kill>
; AVX512VL-NEXT:    shrl $16, %edi
; AVX512VL-NEXT:    shrq $32, %rax
; AVX512VL-NEXT:    shrq $48, %rsi
; AVX512VL-NEXT:    movswl %si, %esi
; AVX512VL-NEXT:    vmovd %esi, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl %di, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %ecx, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    movswl %r10w, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX512VL-NEXT:    movswl %r8w, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX512VL-NEXT:    movswl %dx, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX512VL-NEXT:    vmovd %r9d, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm4, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = bitcast <8 x i16> %a0 to <8 x half>
  %2 = fpext <8 x half> %1 to <8 x float>
  ret <8 x float> %2
}

define <16 x float> @cvt_16i16_to_16f32(<16 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_16i16_to_16f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vmovq %xmm4, %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $48, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm8
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm9
; AVX1-NEXT:    movswl %ax, %ecx
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm10
; AVX1-NEXT:    vpextrq $1, %xmm4, %rax
; AVX1-NEXT:    vmovd %ecx, %xmm11
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $48, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm12
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm13
; AVX1-NEXT:    movswl %ax, %ecx
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm14
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    vmovd %ecx, %xmm15
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $48, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm2
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm3
; AVX1-NEXT:    movswl %ax, %ecx
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm4
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    vmovd %ecx, %xmm0
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $48, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm5
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm6
; AVX1-NEXT:    movl %eax, %ecx
; AVX1-NEXT:    shrl $16, %ecx
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm7
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm8, %xmm8
; AVX1-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX1-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX1-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX1-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX1-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX1-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX1-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm6[0],xmm1[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm5[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0],xmm0[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm15[0],xmm14[0],xmm15[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm13[0],xmm1[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm12[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm11[0],xmm10[0],xmm11[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_16i16_to_16f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vmovq %xmm4, %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $48, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm8
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm9
; AVX2-NEXT:    movswl %ax, %ecx
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm10
; AVX2-NEXT:    vpextrq $1, %xmm4, %rax
; AVX2-NEXT:    vmovd %ecx, %xmm11
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $48, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm12
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm13
; AVX2-NEXT:    movswl %ax, %ecx
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm14
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    vmovd %ecx, %xmm15
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $48, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm2
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm3
; AVX2-NEXT:    movswl %ax, %ecx
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm4
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    vmovd %ecx, %xmm0
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $48, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm5
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm6
; AVX2-NEXT:    movl %eax, %ecx
; AVX2-NEXT:    shrl $16, %ecx
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm7
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm8, %xmm8
; AVX2-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX2-NEXT:    vcvtph2ps %xmm10, %xmm10
; AVX2-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX2-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX2-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX2-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX2-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm7[0],xmm1[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm6[0],xmm1[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm5[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0],xmm0[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm2[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm15[0],xmm14[0],xmm15[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm13[0],xmm1[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm12[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm11[0],xmm10[0],xmm11[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_16i16_to_16f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $48, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm2
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm3
; AVX512F-NEXT:    movswl %ax, %ecx
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512F-NEXT:    vmovd %ecx, %xmm0
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $48, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm5
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm6
; AVX512F-NEXT:    movswl %ax, %ecx
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm7
; AVX512F-NEXT:    vmovq %xmm1, %rax
; AVX512F-NEXT:    vmovd %ecx, %xmm8
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $48, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm9
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm10
; AVX512F-NEXT:    movswl %ax, %ecx
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm11
; AVX512F-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $48, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm12
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm13
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    shrl $16, %ecx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm14
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm15
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm16
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    vcvtph2ps %ymm8, %zmm8
; AVX512F-NEXT:    vcvtph2ps %ymm9, %zmm9
; AVX512F-NEXT:    vcvtph2ps %ymm10, %zmm10
; AVX512F-NEXT:    vcvtph2ps %ymm11, %zmm11
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    vcvtph2ps %ymm12, %zmm12
; AVX512F-NEXT:    vcvtph2ps %ymm13, %zmm13
; AVX512F-NEXT:    vcvtph2ps %ymm14, %zmm14
; AVX512F-NEXT:    vcvtph2ps %ymm15, %zmm15
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm15[0],xmm14[0],xmm15[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm13[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm12[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm10[0],xmm1[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm9[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm8[0],xmm7[0],xmm8[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm6[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm5[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0],xmm0[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm16[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_16i16_to_16f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vextracti32x4 $1, %ymm0, %xmm10
; AVX512VL-NEXT:    vmovq %xmm0, %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $48, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm8
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm9
; AVX512VL-NEXT:    movswl %ax, %ecx
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm11
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512VL-NEXT:    vmovd %ecx, %xmm12
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $48, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm13
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm14
; AVX512VL-NEXT:    movswl %ax, %ecx
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm15
; AVX512VL-NEXT:    vmovq %xmm10, %rax
; AVX512VL-NEXT:    vmovd %ecx, %xmm16
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $48, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm17
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm18
; AVX512VL-NEXT:    movswl %ax, %ecx
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm19
; AVX512VL-NEXT:    vpextrq $1, %xmm10, %rax
; AVX512VL-NEXT:    vmovd %ecx, %xmm10
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $48, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm20
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm21
; AVX512VL-NEXT:    movl %eax, %ecx
; AVX512VL-NEXT:    shrl $16, %ecx
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm22
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm8, %xmm8
; AVX512VL-NEXT:    vcvtph2ps %xmm9, %xmm9
; AVX512VL-NEXT:    vcvtph2ps %xmm11, %xmm11
; AVX512VL-NEXT:    vcvtph2ps %xmm12, %xmm12
; AVX512VL-NEXT:    vcvtph2ps %xmm13, %xmm13
; AVX512VL-NEXT:    vcvtph2ps %xmm14, %xmm14
; AVX512VL-NEXT:    vcvtph2ps %xmm15, %xmm15
; AVX512VL-NEXT:    vcvtph2ps %xmm16, %xmm16
; AVX512VL-NEXT:    vcvtph2ps %xmm17, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm18, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm19, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm10, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm20, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm21, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm22, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm6[0],xmm1[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm3[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm7[0],xmm5[0],xmm7[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm2[0,1],xmm0[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm4[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm16[0],xmm15[0],xmm16[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm14[0],xmm1[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm13[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm12[0],xmm11[0],xmm12[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
  %1 = bitcast <16 x i16> %a0 to <16 x half>
  %2 = fpext <16 x half> %1 to <16 x float>
  ret <16 x float> %2
}

;
; Half to Float (Load)
;

define float @load_cvt_i16_to_f32(i16* %a0) nounwind {
; AVX1-LABEL: load_cvt_i16_to_f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_i16_to_f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_i16_to_f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_i16_to_f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    retq
  %1 = load i16, i16* %a0
  %2 = bitcast i16 %1 to half
  %3 = fpext half %2 to float
  ret float %3
}

define <4 x float> @load_cvt_4i16_to_4f32(<4 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_4i16_to_4f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl 6(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 4(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_4i16_to_4f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl 6(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 4(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_4i16_to_4f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl 6(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl 4(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_4i16_to_4f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl 6(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 4(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = load <4 x i16>, <4 x i16>* %a0
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = fpext <4 x half> %2 to <4 x float>
  ret <4 x float> %3
}

define <4 x float> @load_cvt_8i16_to_4f32(<8 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_8i16_to_4f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movq (%rdi), %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movq %rax, %rdx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrq $48, %rdx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    vmovd %esi, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_8i16_to_4f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movq (%rdi), %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movq %rax, %rdx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrq $48, %rdx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    vmovd %esi, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_8i16_to_4f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movq (%rdi), %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movq %rax, %rdx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrq $48, %rdx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    vmovd %esi, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_8i16_to_4f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movq %rax, %rdx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    # kill: %EAX<def> %EAX<kill> %RAX<kill>
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrq $48, %rdx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %esi, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x i16> %2 to <4 x half>
  %4 = fpext <4 x half> %3 to <4 x float>
  ret <4 x float> %4
}

define <8 x float> @load_cvt_8i16_to_8f32(<8 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_8i16_to_8f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl 6(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 4(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    movswl 14(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm4
; AVX1-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX1-NEXT:    movswl 12(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    movswl 8(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    movswl 10(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    vinsertps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_8i16_to_8f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl 6(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 4(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    movswl 14(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm4
; AVX2-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX2-NEXT:    movswl 12(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    movswl 8(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    movswl 10(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    vinsertps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_8i16_to_8f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl 6(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl 4(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    movswl 14(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    movswl 12(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm5
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    movswl 8(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm6
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    movswl 10(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm7
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_8i16_to_8f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl 6(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 4(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    movswl 14(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX512VL-NEXT:    movswl 12(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX512VL-NEXT:    movswl 8(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX512VL-NEXT:    movswl 10(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm4, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = bitcast <8 x i16> %1 to <8 x half>
  %3 = fpext <8 x half> %2 to <8 x float>
  ret <8 x float> %3
}

define <16 x float> @load_cvt_16i16_to_16f32(<16 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_16i16_to_16f32:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl 22(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm8
; AVX1-NEXT:    movswl 20(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm9
; AVX1-NEXT:    movswl 16(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm10
; AVX1-NEXT:    movswl 18(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm11
; AVX1-NEXT:    movswl 30(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm12
; AVX1-NEXT:    movswl 28(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm13
; AVX1-NEXT:    movswl 24(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm14
; AVX1-NEXT:    movswl 26(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm15
; AVX1-NEXT:    movswl 6(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 4(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm4
; AVX1-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX1-NEXT:    movswl 14(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    movswl 12(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    movswl 8(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    movswl 10(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm7[0],xmm1[0],xmm7[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm6[0],xmm1[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm5[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0,1],xmm2[0],xmm3[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm14[0],xmm15[0],xmm14[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm13[0],xmm1[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm12[0]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm10[0],xmm11[0],xmm10[2,3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX1-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_16i16_to_16f32:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl 22(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm8
; AVX2-NEXT:    movswl 20(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm9
; AVX2-NEXT:    movswl 16(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm10
; AVX2-NEXT:    movswl 18(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm11
; AVX2-NEXT:    movswl 30(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm12
; AVX2-NEXT:    movswl 28(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm13
; AVX2-NEXT:    movswl 24(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm14
; AVX2-NEXT:    movswl 26(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm15
; AVX2-NEXT:    movswl 6(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 4(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm4
; AVX2-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX2-NEXT:    movswl 14(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    movswl 12(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    movswl 8(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    movswl 10(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm7[0],xmm1[0],xmm7[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm6[0],xmm1[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm5[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0,1],xmm2[0],xmm3[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm14[0],xmm15[0],xmm14[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm13[0],xmm1[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm12[0]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm10[0],xmm11[0],xmm10[2,3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_16i16_to_16f32:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl 6(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm16
; AVX512F-NEXT:    movswl 4(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm17
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    movswl 14(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    movswl 12(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm5
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    movswl 8(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm6
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    movswl 10(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm7
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    movswl 22(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm8
; AVX512F-NEXT:    vcvtph2ps %ymm8, %zmm8
; AVX512F-NEXT:    movswl 20(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm9
; AVX512F-NEXT:    vcvtph2ps %ymm9, %zmm9
; AVX512F-NEXT:    movswl 16(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm10
; AVX512F-NEXT:    vcvtph2ps %ymm10, %zmm10
; AVX512F-NEXT:    movswl 18(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm11
; AVX512F-NEXT:    vcvtph2ps %ymm11, %zmm11
; AVX512F-NEXT:    movswl 30(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm12
; AVX512F-NEXT:    vcvtph2ps %ymm12, %zmm12
; AVX512F-NEXT:    movswl 28(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm13
; AVX512F-NEXT:    vcvtph2ps %ymm13, %zmm13
; AVX512F-NEXT:    movswl 24(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm14
; AVX512F-NEXT:    vcvtph2ps %ymm14, %zmm14
; AVX512F-NEXT:    movswl 26(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm15
; AVX512F-NEXT:    vcvtph2ps %ymm15, %zmm15
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm14[0],xmm15[0],xmm14[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm13[0],xmm0[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm12[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm10[0],xmm11[0],xmm10[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm9[0],xmm1[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm8[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm5[0],xmm1[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm4[0]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm17[0],xmm2[3]
; AVX512F-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm16[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX512F-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_16i16_to_16f32:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl 6(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm8
; AVX512VL-NEXT:    movswl 4(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm9
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm10
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm11
; AVX512VL-NEXT:    movswl 14(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm12
; AVX512VL-NEXT:    movswl 12(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm13
; AVX512VL-NEXT:    movswl 8(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm14
; AVX512VL-NEXT:    movswl 10(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm15
; AVX512VL-NEXT:    movswl 22(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 20(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl 16(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl 18(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    movswl 30(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX512VL-NEXT:    movswl 28(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX512VL-NEXT:    movswl 24(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX512VL-NEXT:    movswl 26(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm6 = xmm6[0],xmm7[0],xmm6[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm5 = xmm6[0,1],xmm5[0],xmm6[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm4 = xmm5[0,1,2],xmm4[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0,1],xmm1[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm14[0],xmm15[0],xmm14[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm13[0],xmm1[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm12[0]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm10[0],xmm11[0],xmm10[2,3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm9[0],xmm2[3]
; AVX512VL-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm8[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vinsertf64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
  %1 = load <16 x i16>, <16 x i16>* %a0
  %2 = bitcast <16 x i16> %1 to <16 x half>
  %3 = fpext <16 x half> %2 to <16 x float>
  ret <16 x float> %3
}

;
; Half to Double
;

define double @cvt_i16_to_f64(i16 %a0) nounwind {
; AVX1-LABEL: cvt_i16_to_f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl %di, %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_i16_to_f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl %di, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_i16_to_f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl %di, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_i16_to_f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl %di, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
  %1 = bitcast i16 %a0 to half
  %2 = fpext half %1 to double
  ret double %2
}

define <2 x double> @cvt_2i16_to_2f64(<2 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_2i16_to_2f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    movswl %ax, %ecx
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %ecx, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_2i16_to_2f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX2-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    movswl %ax, %ecx
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %ecx, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_2i16_to_2f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512F-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    movswl %ax, %ecx
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_2i16_to_2f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovqw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movl -{{[0-9]+}}(%rsp), %eax
; AVX512VL-NEXT:    movswl %ax, %ecx
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = bitcast <2 x i16> %a0 to <2 x half>
  %2 = fpext <2 x half> %1 to <2 x double>
  ret <2 x double> %2
}

define <4 x double> @cvt_4i16_to_4f64(<4 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_4i16_to_4f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movl %eax, %edx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    shrq $48, %rax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrl $16, %edx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %esi, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4i16_to_4f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movl %eax, %edx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    shrq $48, %rax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrl $16, %edx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %esi, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4i16_to_4f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movl %eax, %edx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    shrq $48, %rax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrl $16, %edx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %esi, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4i16_to_4f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movl %eax, %edx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    shrq $48, %rax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrl $16, %edx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %esi, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = bitcast <4 x i16> %a0 to <4 x half>
  %2 = fpext <4 x half> %1 to <4 x double>
  ret <4 x double> %2
}

define <2 x double> @cvt_8i16_to_2f64(<8 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_8i16_to_2f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    movswl %ax, %ecx
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %ecx, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8i16_to_2f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    movswl %ax, %ecx
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %ecx, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8i16_to_2f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    movswl %ax, %ecx
; AVX512F-NEXT:    shrl $16, %eax
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %ecx, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8i16_to_2f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512VL-NEXT:    vpmovqw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movl -{{[0-9]+}}(%rsp), %eax
; AVX512VL-NEXT:    movswl %ax, %ecx
; AVX512VL-NEXT:    shrl $16, %eax
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <2 x i32> <i32 0, i32 1>
  %2 = bitcast <2 x i16> %1 to <2 x half>
  %3 = fpext <2 x half> %2 to <2 x double>
  ret <2 x double> %3
}

define <4 x double> @cvt_8i16_to_4f64(<8 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_8i16_to_4f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovq %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movl %eax, %edx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    shrq $48, %rax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrl $16, %edx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %esi, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8i16_to_4f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovq %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movl %eax, %edx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    shrq $48, %rax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrl $16, %edx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %esi, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8i16_to_4f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vmovq %xmm0, %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movl %eax, %edx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    shrq $48, %rax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrl $16, %edx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %esi, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8i16_to_4f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movl %eax, %edx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    shrq $48, %rax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrl $16, %edx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %esi, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = shufflevector <8 x i16> %a0, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = fpext <4 x half> %2 to <4 x double>
  ret <4 x double> %3
}

define <8 x double> @cvt_8i16_to_8f64(<8 x i16> %a0) nounwind {
; AVX1-LABEL: cvt_8i16_to_8f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovq %xmm0, %rdx
; AVX1-NEXT:    movq %rdx, %r9
; AVX1-NEXT:    movl %edx, %r10d
; AVX1-NEXT:    movswl %dx, %r8d
; AVX1-NEXT:    shrq $48, %rdx
; AVX1-NEXT:    shrq $32, %r9
; AVX1-NEXT:    shrl $16, %r10d
; AVX1-NEXT:    vpextrq $1, %xmm0, %rdi
; AVX1-NEXT:    movq %rdi, %rsi
; AVX1-NEXT:    movl %edi, %eax
; AVX1-NEXT:    movswl %di, %ecx
; AVX1-NEXT:    shrq $48, %rdi
; AVX1-NEXT:    shrq $32, %rsi
; AVX1-NEXT:    shrl $16, %eax
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm1
; AVX1-NEXT:    vmovd %ecx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX1-NEXT:    movswl %si, %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm3
; AVX1-NEXT:    movswl %di, %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm4
; AVX1-NEXT:    movswl %r10w, %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %r8d, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    movswl %r9w, %eax
; AVX1-NEXT:    vmovd %eax, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    movswl %dx, %eax
; AVX1-NEXT:    vmovd %eax, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX1-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm5[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8i16_to_8f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovq %xmm0, %rdx
; AVX2-NEXT:    movq %rdx, %r9
; AVX2-NEXT:    movl %edx, %r10d
; AVX2-NEXT:    movswl %dx, %r8d
; AVX2-NEXT:    shrq $48, %rdx
; AVX2-NEXT:    shrq $32, %r9
; AVX2-NEXT:    shrl $16, %r10d
; AVX2-NEXT:    vpextrq $1, %xmm0, %rdi
; AVX2-NEXT:    movq %rdi, %rsi
; AVX2-NEXT:    movl %edi, %eax
; AVX2-NEXT:    movswl %di, %ecx
; AVX2-NEXT:    shrq $48, %rdi
; AVX2-NEXT:    shrq $32, %rsi
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm1
; AVX2-NEXT:    vmovd %ecx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX2-NEXT:    movswl %si, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm3
; AVX2-NEXT:    movswl %di, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm4
; AVX2-NEXT:    movswl %r10w, %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %r8d, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    movswl %r9w, %eax
; AVX2-NEXT:    vmovd %eax, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    movswl %dx, %eax
; AVX2-NEXT:    vmovd %eax, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX2-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX2-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm5[0],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX2-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8i16_to_8f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX512F-NEXT:    movq %rdx, %r8
; AVX512F-NEXT:    movl %edx, %r9d
; AVX512F-NEXT:    movswl %dx, %r10d
; AVX512F-NEXT:    shrq $48, %rdx
; AVX512F-NEXT:    shrq $32, %r8
; AVX512F-NEXT:    shrl $16, %r9d
; AVX512F-NEXT:    vmovq %xmm0, %rdi
; AVX512F-NEXT:    movq %rdi, %rax
; AVX512F-NEXT:    movl %edi, %ecx
; AVX512F-NEXT:    movswl %di, %esi
; AVX512F-NEXT:    shrq $48, %rdi
; AVX512F-NEXT:    shrq $32, %rax
; AVX512F-NEXT:    shrl $16, %ecx
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %esi, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl %di, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    movswl %r9w, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    vmovd %r10d, %xmm5
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    movswl %r8w, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm6
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    movswl %dx, %eax
; AVX512F-NEXT:    vmovd %eax, %xmm7
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX512F-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX512F-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX512F-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinsertf64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8i16_to_8f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rdx
; AVX512VL-NEXT:    movq %rdx, %r8
; AVX512VL-NEXT:    movl %edx, %r10d
; AVX512VL-NEXT:    movswl %dx, %r9d
; AVX512VL-NEXT:    shrq $48, %rdx
; AVX512VL-NEXT:    shrq $32, %r8
; AVX512VL-NEXT:    shrl $16, %r10d
; AVX512VL-NEXT:    vmovq %xmm0, %rdi
; AVX512VL-NEXT:    movq %rdi, %rax
; AVX512VL-NEXT:    movl %edi, %esi
; AVX512VL-NEXT:    movswl %di, %ecx
; AVX512VL-NEXT:    shrq $48, %rdi
; AVX512VL-NEXT:    shrq $32, %rax
; AVX512VL-NEXT:    shrl $16, %esi
; AVX512VL-NEXT:    movswl %si, %esi
; AVX512VL-NEXT:    vmovd %esi, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %ecx, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl %di, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    movswl %r10w, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX512VL-NEXT:    vmovd %r9d, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX512VL-NEXT:    movswl %r8w, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX512VL-NEXT:    movswl %dx, %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX512VL-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX512VL-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX512VL-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm5[0],xmm4[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vinsertf64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
  %1 = bitcast <8 x i16> %a0 to <8 x half>
  %2 = fpext <8 x half> %1 to <8 x double>
  ret <8 x double> %2
}

;
; Half to Double (Load)
;

define double @load_cvt_i16_to_f64(i16* %a0) nounwind {
; AVX1-LABEL: load_cvt_i16_to_f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_i16_to_f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_i16_to_f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_i16_to_f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
  %1 = load i16, i16* %a0
  %2 = bitcast i16 %1 to half
  %3 = fpext half %2 to double
  ret double %3
}

define <2 x double> @load_cvt_2i16_to_2f64(<2 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_2i16_to_2f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_2i16_to_2f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_2i16_to_2f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_2i16_to_2f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    retq
  %1 = load <2 x i16>, <2 x i16>* %a0
  %2 = bitcast <2 x i16> %1 to <2 x half>
  %3 = fpext <2 x half> %2 to <2 x double>
  ret <2 x double> %3
}

define <4 x double> @load_cvt_4i16_to_4f64(<4 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_4i16_to_4f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl 4(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    movswl 6(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_4i16_to_4f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl 4(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    movswl 6(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_4i16_to_4f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl 4(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl 6(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_4i16_to_4f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl 4(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl 6(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = load <4 x i16>, <4 x i16>* %a0
  %2 = bitcast <4 x i16> %1 to <4 x half>
  %3 = fpext <4 x half> %2 to <4 x double>
  ret <4 x double> %3
}

define <4 x double> @load_cvt_8i16_to_4f64(<8 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_8i16_to_4f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movq (%rdi), %rax
; AVX1-NEXT:    movq %rax, %rcx
; AVX1-NEXT:    movl %eax, %edx
; AVX1-NEXT:    movswl %ax, %esi
; AVX1-NEXT:    shrq $48, %rax
; AVX1-NEXT:    shrq $32, %rcx
; AVX1-NEXT:    shrl $16, %edx
; AVX1-NEXT:    movswl %dx, %edx
; AVX1-NEXT:    vmovd %edx, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    vmovd %esi, %xmm1
; AVX1-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX1-NEXT:    movswl %cx, %ecx
; AVX1-NEXT:    vmovd %ecx, %xmm2
; AVX1-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX1-NEXT:    cwtl
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_8i16_to_4f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movq (%rdi), %rax
; AVX2-NEXT:    movq %rax, %rcx
; AVX2-NEXT:    movl %eax, %edx
; AVX2-NEXT:    movswl %ax, %esi
; AVX2-NEXT:    shrq $48, %rax
; AVX2-NEXT:    shrq $32, %rcx
; AVX2-NEXT:    shrl $16, %edx
; AVX2-NEXT:    movswl %dx, %edx
; AVX2-NEXT:    vmovd %edx, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    vmovd %esi, %xmm1
; AVX2-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX2-NEXT:    movswl %cx, %ecx
; AVX2-NEXT:    vmovd %ecx, %xmm2
; AVX2-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX2-NEXT:    cwtl
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_8i16_to_4f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movq (%rdi), %rax
; AVX512F-NEXT:    movq %rax, %rcx
; AVX512F-NEXT:    movl %eax, %edx
; AVX512F-NEXT:    movswl %ax, %esi
; AVX512F-NEXT:    shrq $48, %rax
; AVX512F-NEXT:    shrq $32, %rcx
; AVX512F-NEXT:    shrl $16, %edx
; AVX512F-NEXT:    movswl %dx, %edx
; AVX512F-NEXT:    vmovd %edx, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    vmovd %esi, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl %cx, %ecx
; AVX512F-NEXT:    vmovd %ecx, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    cwtl
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_8i16_to_4f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} xmm0 = mem[0],zero,mem[1],zero,mem[2],zero,mem[3],zero
; AVX512VL-NEXT:    vpmovdw %xmm0, -{{[0-9]+}}(%rsp)
; AVX512VL-NEXT:    movq -{{[0-9]+}}(%rsp), %rax
; AVX512VL-NEXT:    movq %rax, %rcx
; AVX512VL-NEXT:    movl %eax, %edx
; AVX512VL-NEXT:    movswl %ax, %esi
; AVX512VL-NEXT:    shrq $48, %rax
; AVX512VL-NEXT:    shrq $32, %rcx
; AVX512VL-NEXT:    shrl $16, %edx
; AVX512VL-NEXT:    movswl %dx, %edx
; AVX512VL-NEXT:    vmovd %edx, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %esi, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl %cx, %ecx
; AVX512VL-NEXT:    vmovd %ecx, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    cwtl
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = shufflevector <8 x i16> %1, <8 x i16> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = bitcast <4 x i16> %2 to <4 x half>
  %4 = fpext <4 x half> %3 to <4 x double>
  ret <4 x double> %4
}

define <8 x double> @load_cvt_8i16_to_8f64(<8 x i16>* %a0) nounwind {
; AVX1-LABEL: load_cvt_8i16_to_8f64:
; AVX1:       # BB#0:
; AVX1-NEXT:    movswl 8(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm1
; AVX1-NEXT:    movswl 10(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX1-NEXT:    movswl 12(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm3
; AVX1-NEXT:    movswl 14(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm4
; AVX1-NEXT:    movswl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX1-NEXT:    movswl 2(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm5
; AVX1-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX1-NEXT:    movswl 4(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm6
; AVX1-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX1-NEXT:    movswl 6(%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm7
; AVX1-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX1-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX1-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX1-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX1-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_cvt_8i16_to_8f64:
; AVX2:       # BB#0:
; AVX2-NEXT:    movswl 8(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm1
; AVX2-NEXT:    movswl 10(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm2
; AVX2-NEXT:    movswl 12(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm3
; AVX2-NEXT:    movswl 14(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm4
; AVX2-NEXT:    movswl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX2-NEXT:    movswl 2(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm5
; AVX2-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX2-NEXT:    movswl 4(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm6
; AVX2-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX2-NEXT:    movswl 6(%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm7
; AVX2-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX2-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX2-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX2-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX2-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; AVX2-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_cvt_8i16_to_8f64:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    movswl (%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm0
; AVX512F-NEXT:    vcvtph2ps %ymm0, %zmm0
; AVX512F-NEXT:    movswl 2(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm1
; AVX512F-NEXT:    vcvtph2ps %ymm1, %zmm1
; AVX512F-NEXT:    movswl 4(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm2
; AVX512F-NEXT:    vcvtph2ps %ymm2, %zmm2
; AVX512F-NEXT:    movswl 6(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vcvtph2ps %ymm3, %zmm3
; AVX512F-NEXT:    movswl 8(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm4
; AVX512F-NEXT:    vcvtph2ps %ymm4, %zmm4
; AVX512F-NEXT:    movswl 10(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm5
; AVX512F-NEXT:    vcvtph2ps %ymm5, %zmm5
; AVX512F-NEXT:    movswl 12(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm6
; AVX512F-NEXT:    vcvtph2ps %ymm6, %zmm6
; AVX512F-NEXT:    movswl 14(%rdi), %eax
; AVX512F-NEXT:    vmovd %eax, %xmm7
; AVX512F-NEXT:    vcvtph2ps %ymm7, %zmm7
; AVX512F-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX512F-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX512F-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX512F-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX512F-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512F-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512F-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512F-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    vinsertf64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: load_cvt_8i16_to_8f64:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    movswl (%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm0
; AVX512VL-NEXT:    vcvtph2ps %xmm0, %xmm0
; AVX512VL-NEXT:    movswl 2(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm1
; AVX512VL-NEXT:    vcvtph2ps %xmm1, %xmm1
; AVX512VL-NEXT:    movswl 4(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm2
; AVX512VL-NEXT:    vcvtph2ps %xmm2, %xmm2
; AVX512VL-NEXT:    movswl 6(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vcvtph2ps %xmm3, %xmm3
; AVX512VL-NEXT:    movswl 8(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm4
; AVX512VL-NEXT:    vcvtph2ps %xmm4, %xmm4
; AVX512VL-NEXT:    movswl 10(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm5
; AVX512VL-NEXT:    vcvtph2ps %xmm5, %xmm5
; AVX512VL-NEXT:    movswl 12(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm6
; AVX512VL-NEXT:    vcvtph2ps %xmm6, %xmm6
; AVX512VL-NEXT:    movswl 14(%rdi), %eax
; AVX512VL-NEXT:    vmovd %eax, %xmm7
; AVX512VL-NEXT:    vcvtph2ps %xmm7, %xmm7
; AVX512VL-NEXT:    vcvtss2sd %xmm7, %xmm7, %xmm7
; AVX512VL-NEXT:    vcvtss2sd %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm6 = xmm6[0],xmm7[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm5, %xmm5, %xmm5
; AVX512VL-NEXT:    vcvtss2sd %xmm4, %xmm4, %xmm4
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm6, %ymm4, %ymm4
; AVX512VL-NEXT:    vcvtss2sd %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vcvtss2sd %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; AVX512VL-NEXT:    vcvtss2sd %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; AVX512VL-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX512VL-NEXT:    vinsertf32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vinsertf64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
  %1 = load <8 x i16>, <8 x i16>* %a0
  %2 = bitcast <8 x i16> %1 to <8 x half>
  %3 = fpext <8 x half> %2 to <8 x double>
  ret <8 x double> %3
}

;
; Float to Half
;

define i16 @cvt_f32_to_i16(float %a0) nounwind {
; AVX1-LABEL: cvt_f32_to_i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    # kill: %AX<def> %AX<kill> %EAX<kill>
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_f32_to_i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    # kill: %AX<def> %AX<kill> %EAX<kill>
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_f32_to_i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    # kill: %AX<def> %AX<kill> %EAX<kill>
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_f32_to_i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    # kill: %AX<def> %AX<kill> %EAX<kill>
; AVX512VL-NEXT:    retq
  %1 = fptrunc float %a0 to half
  %2 = bitcast half %1 to i16
  ret i16 %2
}

define <4 x i16> @cvt_4f32_to_4i16(<4 x float> %a0) nounwind {
; AVX1-LABEL: cvt_4f32_to_4i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    shlq $32, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f32_to_4i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %eax, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f32_to_4i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %eax, %edx
; AVX512F-NEXT:    shlq $32, %rdx
; AVX512F-NEXT:    orq %rcx, %rdx
; AVX512F-NEXT:    vmovq %rdx, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f32_to_4i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %eax, %edx
; AVX512VL-NEXT:    shlq $32, %rdx
; AVX512VL-NEXT:    orq %rcx, %rdx
; AVX512VL-NEXT:    vmovq %rdx, %xmm0
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  ret <4 x i16> %2
}

define <8 x i16> @cvt_4f32_to_8i16_undef(<4 x float> %a0) nounwind {
; AVX1-LABEL: cvt_4f32_to_8i16_undef:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    shlq $32, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f32_to_8i16_undef:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %eax, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f32_to_8i16_undef:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %eax, %edx
; AVX512F-NEXT:    shlq $32, %rdx
; AVX512F-NEXT:    orq %rcx, %rdx
; AVX512F-NEXT:    vmovq %rdx, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f32_to_8i16_undef:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %eax, %edx
; AVX512VL-NEXT:    shlq $32, %rdx
; AVX512VL-NEXT:    orq %rcx, %rdx
; AVX512VL-NEXT:    vmovq %rdx, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %3
}

define <8 x i16> @cvt_4f32_to_8i16_zero(<4 x float> %a0) nounwind {
; AVX1-LABEL: cvt_4f32_to_8i16_zero:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    shlq $32, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f32_to_8i16_zero:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %eax, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f32_to_8i16_zero:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %eax, %edx
; AVX512F-NEXT:    shlq $32, %rdx
; AVX512F-NEXT:    orq %rcx, %rdx
; AVX512F-NEXT:    vmovq %rdx, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f32_to_8i16_zero:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %eax, %edx
; AVX512VL-NEXT:    shlq $32, %rdx
; AVX512VL-NEXT:    orq %rcx, %rdx
; AVX512VL-NEXT:    vmovq %rdx, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; AVX512VL-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %3
}

define <8 x i16> @cvt_8f32_to_8i16(<8 x float> %a0) nounwind {
; AVX1-LABEL: cvt_8f32_to_8i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %edx
; AVX1-NEXT:    shll $16, %edx
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %edx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %rcx, %rax
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    shll $16, %ecx
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %ecx, %edx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    shll $16, %ecx
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %esi
; AVX1-NEXT:    movzwl %si, %esi
; AVX1-NEXT:    orl %ecx, %esi
; AVX1-NEXT:    shlq $32, %rsi
; AVX1-NEXT:    orq %rdx, %rsi
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8f32_to_8i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %edx
; AVX2-NEXT:    shll $16, %edx
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %edx, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %rcx, %rax
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    shll $16, %ecx
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %ecx, %edx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    shll $16, %ecx
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %esi
; AVX2-NEXT:    movzwl %si, %esi
; AVX2-NEXT:    orl %ecx, %esi
; AVX2-NEXT:    shlq $32, %rsi
; AVX2-NEXT:    orq %rdx, %rsi
; AVX2-NEXT:    vmovq %rsi, %xmm0
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8f32_to_8i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %edx
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    shll $16, %eax
; AVX512F-NEXT:    orl %edx, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %rcx, %rax
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    movzwl %cx, %ecx
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %ecx, %edx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    movzwl %cx, %ecx
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %esi
; AVX512F-NEXT:    shll $16, %esi
; AVX512F-NEXT:    orl %ecx, %esi
; AVX512F-NEXT:    shlq $32, %rsi
; AVX512F-NEXT:    orq %rdx, %rsi
; AVX512F-NEXT:    vmovq %rsi, %xmm0
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8f32_to_8i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %edx
; AVX512VL-NEXT:    shll $16, %edx
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %edx, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %rcx, %rax
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    shll $16, %ecx
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %ecx, %edx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    shll $16, %ecx
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %esi
; AVX512VL-NEXT:    movzwl %si, %esi
; AVX512VL-NEXT:    orl %ecx, %esi
; AVX512VL-NEXT:    shlq $32, %rsi
; AVX512VL-NEXT:    orq %rdx, %rsi
; AVX512VL-NEXT:    vmovq %rsi, %xmm0
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    retq
  %1 = fptrunc <8 x float> %a0 to <8 x half>
  %2 = bitcast <8 x half> %1 to <8 x i16>
  ret <8 x i16> %2
}

define <16 x i16> @cvt_16f32_to_16i16(<16 x float> %a0) nounwind {
; AVX1-LABEL: cvt_16f32_to_16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm2
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm1
; AVX1-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm2[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    vpinsrw $7, %eax, %xmm3, %xmm2
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %eax, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX1-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm1[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm1
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_16f32_to_16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm2
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm1
; AVX2-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm2[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    vpinsrw $7, %eax, %xmm3, %xmm2
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %eax, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX2-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm1[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm1
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX2-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_16f32_to_16i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm2
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm1
; AVX512F-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm2[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vpinsrw $7, %eax, %xmm3, %xmm2
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %eax, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm0
; AVX512F-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm1[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm1[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm1
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX512F-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_16f32_to_16i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vextractf64x4 $1, %zmm0, %ymm1
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm2
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm1, %xmm2
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm1
; AVX512VL-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm2[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vpinsrw $7, %eax, %xmm3, %xmm2
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %eax, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpinsrw $1, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpinsrw $2, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX512VL-NEXT:    vpinsrw $3, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm1[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpinsrw $4, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm1[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpinsrw $5, %eax, %xmm3, %xmm3
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm1[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpinsrw $6, %eax, %xmm3, %xmm1
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    vpinsrw $7, %eax, %xmm1, %xmm0
; AVX512VL-NEXT:    vinserti32x4 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %1 = fptrunc <16 x float> %a0 to <16 x half>
  %2 = bitcast <16 x half> %1 to <16 x i16>
  ret <16 x i16> %2
}

;
; Float to Half (Store)
;

define void @store_cvt_f32_to_i16(float %a0, i16* %a1) nounwind {
; AVX1-LABEL: store_cvt_f32_to_i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    movw %ax, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_f32_to_i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    movw %ax, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_f32_to_i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    movw %ax, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_f32_to_i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    movw %ax, (%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc float %a0 to half
  %2 = bitcast half %1 to i16
  store i16 %2, i16* %a1
  ret void
}

define void @store_cvt_4f32_to_4i16(<4 x float> %a0, <4 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f32_to_4i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %edx
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %esi
; AVX1-NEXT:    movw %si, (%rdi)
; AVX1-NEXT:    movw %dx, 6(%rdi)
; AVX1-NEXT:    movw %cx, 4(%rdi)
; AVX1-NEXT:    movw %ax, 2(%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f32_to_4i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %edx
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %esi
; AVX2-NEXT:    movw %si, (%rdi)
; AVX2-NEXT:    movw %dx, 6(%rdi)
; AVX2-NEXT:    movw %cx, 4(%rdi)
; AVX2-NEXT:    movw %ax, 2(%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f32_to_4i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %edx
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %esi
; AVX512F-NEXT:    movw %si, (%rdi)
; AVX512F-NEXT:    movw %dx, 6(%rdi)
; AVX512F-NEXT:    movw %cx, 4(%rdi)
; AVX512F-NEXT:    movw %ax, 2(%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f32_to_4i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %edx
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %esi
; AVX512VL-NEXT:    movw %si, (%rdi)
; AVX512VL-NEXT:    movw %dx, 6(%rdi)
; AVX512VL-NEXT:    movw %cx, 4(%rdi)
; AVX512VL-NEXT:    movw %ax, 2(%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  store <4 x i16> %2, <4 x i16>* %a1
  ret void
}

define void @store_cvt_4f32_to_8i16_undef(<4 x float> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f32_to_8i16_undef:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    shlq $32, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f32_to_8i16_undef:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %eax, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f32_to_8i16_undef:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %eax, %edx
; AVX512F-NEXT:    shlq $32, %rdx
; AVX512F-NEXT:    orq %rcx, %rdx
; AVX512F-NEXT:    vmovq %rdx, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f32_to_8i16_undef:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %eax, %edx
; AVX512VL-NEXT:    shlq $32, %rdx
; AVX512VL-NEXT:    orq %rcx, %rdx
; AVX512VL-NEXT:    vmovq %rdx, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512VL-NEXT:    vmovdqa32 %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i16> %3, <8 x i16>* %a1
  ret void
}

define void @store_cvt_4f32_to_8i16_zero(<4 x float> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f32_to_8i16_zero:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %ecx
; AVX1-NEXT:    movzwl %cx, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    movzwl %dx, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    shlq $32, %rdx
; AVX1-NEXT:    orq %rcx, %rdx
; AVX1-NEXT:    vmovq %rdx, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f32_to_8i16_zero:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %ecx
; AVX2-NEXT:    movzwl %cx, %ecx
; AVX2-NEXT:    orl %eax, %ecx
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    shll $16, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    movzwl %dx, %edx
; AVX2-NEXT:    orl %eax, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    orq %rcx, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f32_to_8i16_zero:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %ecx
; AVX512F-NEXT:    shll $16, %ecx
; AVX512F-NEXT:    orl %eax, %ecx
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    shll $16, %edx
; AVX512F-NEXT:    orl %eax, %edx
; AVX512F-NEXT:    shlq $32, %rdx
; AVX512F-NEXT:    orq %rcx, %rdx
; AVX512F-NEXT:    vmovq %rdx, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f32_to_8i16_zero:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %ecx
; AVX512VL-NEXT:    movzwl %cx, %ecx
; AVX512VL-NEXT:    orl %eax, %ecx
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    shll $16, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    movzwl %dx, %edx
; AVX512VL-NEXT:    orl %eax, %edx
; AVX512VL-NEXT:    shlq $32, %rdx
; AVX512VL-NEXT:    orq %rcx, %rdx
; AVX512VL-NEXT:    vmovq %rdx, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; AVX512VL-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512VL-NEXT:    vmovdqa32 %xmm0, (%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x float> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i16> %3, <8 x i16>* %a1
  ret void
}

define void @store_cvt_8f32_to_8i16(<8 x float> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_8f32_to_8i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %r8d
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %r9d
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vmovd %xmm1, %r10d
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vmovd %xmm2, %r11d
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    vmovd %xmm2, %ecx
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %edx
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX1-NEXT:    vmovd %xmm0, %esi
; AVX1-NEXT:    movw %si, 8(%rdi)
; AVX1-NEXT:    movw %dx, (%rdi)
; AVX1-NEXT:    movw %cx, 14(%rdi)
; AVX1-NEXT:    movw %ax, 12(%rdi)
; AVX1-NEXT:    movw %r11w, 10(%rdi)
; AVX1-NEXT:    movw %r10w, 6(%rdi)
; AVX1-NEXT:    movw %r9w, 4(%rdi)
; AVX1-NEXT:    movw %r8w, 2(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_8f32_to_8i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %r8d
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %r9d
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vmovd %xmm1, %r10d
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vmovd %xmm2, %r11d
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    vmovd %xmm2, %ecx
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %edx
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX2-NEXT:    vmovd %xmm0, %esi
; AVX2-NEXT:    movw %si, 8(%rdi)
; AVX2-NEXT:    movw %dx, (%rdi)
; AVX2-NEXT:    movw %cx, 14(%rdi)
; AVX2-NEXT:    movw %ax, 12(%rdi)
; AVX2-NEXT:    movw %r11w, 10(%rdi)
; AVX2-NEXT:    movw %r10w, 6(%rdi)
; AVX2-NEXT:    movw %r9w, 4(%rdi)
; AVX2-NEXT:    movw %r8w, 2(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_8f32_to_8i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    # kill: %YMM0<def> %YMM0<kill> %ZMM0<def>
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %r8d
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %r9d
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    vmovd %xmm1, %r10d
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vmovd %xmm2, %r11d
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vmovd %xmm2, %ecx
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %edx
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm0
; AVX512F-NEXT:    vmovd %xmm0, %esi
; AVX512F-NEXT:    movw %si, 8(%rdi)
; AVX512F-NEXT:    movw %dx, (%rdi)
; AVX512F-NEXT:    movw %cx, 14(%rdi)
; AVX512F-NEXT:    movw %ax, 12(%rdi)
; AVX512F-NEXT:    movw %r11w, 10(%rdi)
; AVX512F-NEXT:    movw %r10w, 6(%rdi)
; AVX512F-NEXT:    movw %r9w, 4(%rdi)
; AVX512F-NEXT:    movw %r8w, 2(%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_8f32_to_8i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %r8d
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %r9d
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vmovd %xmm1, %r10d
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %xmm2, %r11d
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm1[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vmovd %xmm2, %ecx
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %edx
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm0
; AVX512VL-NEXT:    vmovd %xmm0, %esi
; AVX512VL-NEXT:    movw %si, 8(%rdi)
; AVX512VL-NEXT:    movw %dx, (%rdi)
; AVX512VL-NEXT:    movw %cx, 14(%rdi)
; AVX512VL-NEXT:    movw %ax, 12(%rdi)
; AVX512VL-NEXT:    movw %r11w, 10(%rdi)
; AVX512VL-NEXT:    movw %r10w, 6(%rdi)
; AVX512VL-NEXT:    movw %r9w, 4(%rdi)
; AVX512VL-NEXT:    movw %r8w, 2(%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc <8 x float> %a0 to <8 x half>
  %2 = bitcast <8 x half> %1 to <8 x i16>
  store <8 x i16> %2, <8 x i16>* %a1
  ret void
}

define void @store_cvt_16f32_to_16i16(<16 x float> %a0, <16 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_16f32_to_16i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vcvtps2ph $4, %xmm3, %xmm4
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm4
; AVX1-NEXT:    movw %ax, 24(%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm4
; AVX1-NEXT:    movw %ax, 16(%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm4
; AVX1-NEXT:    movw %ax, 8(%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vpermilps {{.*#+}} xmm4 = xmm3[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX1-NEXT:    movw %ax, (%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm3[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX1-NEXT:    movw %ax, 30(%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX1-NEXT:    movw %ax, 28(%rdi)
; AVX1-NEXT:    vmovd %xmm3, %eax
; AVX1-NEXT:    vpermilps {{.*#+}} xmm3 = xmm1[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX1-NEXT:    movw %ax, 26(%rdi)
; AVX1-NEXT:    vmovd %xmm3, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm1[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX1-NEXT:    movw %ax, 22(%rdi)
; AVX1-NEXT:    vmovd %xmm3, %eax
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX1-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm1[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    movw %ax, 20(%rdi)
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[3,1,2,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    movw %ax, 18(%rdi)
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX1-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX1-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX1-NEXT:    movw %ax, 14(%rdi)
; AVX1-NEXT:    vmovd %xmm2, %eax
; AVX1-NEXT:    movw %ax, 12(%rdi)
; AVX1-NEXT:    vmovd %xmm1, %eax
; AVX1-NEXT:    movw %ax, 10(%rdi)
; AVX1-NEXT:    vmovd %xmm0, %eax
; AVX1-NEXT:    movw %ax, 6(%rdi)
; AVX1-NEXT:    vmovd %xmm3, %eax
; AVX1-NEXT:    movw %ax, 4(%rdi)
; AVX1-NEXT:    vmovd %xmm4, %eax
; AVX1-NEXT:    movw %ax, 2(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_16f32_to_16i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX2-NEXT:    vcvtps2ph $4, %xmm3, %xmm4
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm4
; AVX2-NEXT:    movw %ax, 24(%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm4
; AVX2-NEXT:    movw %ax, 16(%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm4
; AVX2-NEXT:    movw %ax, 8(%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vpermilps {{.*#+}} xmm4 = xmm3[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX2-NEXT:    movw %ax, (%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm3[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX2-NEXT:    movw %ax, 30(%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX2-NEXT:    movw %ax, 28(%rdi)
; AVX2-NEXT:    vmovd %xmm3, %eax
; AVX2-NEXT:    vpermilps {{.*#+}} xmm3 = xmm1[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX2-NEXT:    movw %ax, 26(%rdi)
; AVX2-NEXT:    vmovd %xmm3, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm1[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX2-NEXT:    movw %ax, 22(%rdi)
; AVX2-NEXT:    vmovd %xmm3, %eax
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX2-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm1[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    movw %ax, 20(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm2[3,1,2,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    movw %ax, 18(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm2[1,1,3,3]
; AVX2-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX2-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX2-NEXT:    movw %ax, 14(%rdi)
; AVX2-NEXT:    vmovd %xmm2, %eax
; AVX2-NEXT:    movw %ax, 12(%rdi)
; AVX2-NEXT:    vmovd %xmm1, %eax
; AVX2-NEXT:    movw %ax, 10(%rdi)
; AVX2-NEXT:    vmovd %xmm0, %eax
; AVX2-NEXT:    movw %ax, 6(%rdi)
; AVX2-NEXT:    vmovd %xmm3, %eax
; AVX2-NEXT:    movw %ax, 4(%rdi)
; AVX2-NEXT:    vmovd %xmm4, %eax
; AVX2-NEXT:    movw %ax, 2(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_16f32_to_16i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512F-NEXT:    vextractf64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX512F-NEXT:    vcvtps2ph $4, %zmm3, %ymm4
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm4
; AVX512F-NEXT:    movw %ax, 24(%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm4
; AVX512F-NEXT:    movw %ax, 16(%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm4
; AVX512F-NEXT:    movw %ax, 8(%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm4 = xmm3[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm4, %ymm4
; AVX512F-NEXT:    movw %ax, (%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm3[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm4, %ymm4
; AVX512F-NEXT:    movw %ax, 30(%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm4, %ymm4
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm3, %ymm3
; AVX512F-NEXT:    movw %ax, 28(%rdi)
; AVX512F-NEXT:    vmovd %xmm3, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm3 = xmm2[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm3, %ymm3
; AVX512F-NEXT:    movw %ax, 26(%rdi)
; AVX512F-NEXT:    vmovd %xmm3, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm3, %ymm3
; AVX512F-NEXT:    movw %ax, 22(%rdi)
; AVX512F-NEXT:    vmovd %xmm3, %eax
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm3, %ymm3
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm0, %ymm0
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm2[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    movw %ax, 20(%rdi)
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    movw %ax, 18(%rdi)
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm2, %ymm2
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512F-NEXT:    vcvtps2ph $4, %zmm1, %ymm1
; AVX512F-NEXT:    movw %ax, 14(%rdi)
; AVX512F-NEXT:    vmovd %xmm1, %eax
; AVX512F-NEXT:    movw %ax, 12(%rdi)
; AVX512F-NEXT:    vmovd %xmm2, %eax
; AVX512F-NEXT:    movw %ax, 10(%rdi)
; AVX512F-NEXT:    vmovd %xmm0, %eax
; AVX512F-NEXT:    movw %ax, 6(%rdi)
; AVX512F-NEXT:    vmovd %xmm3, %eax
; AVX512F-NEXT:    movw %ax, 4(%rdi)
; AVX512F-NEXT:    vmovd %xmm4, %eax
; AVX512F-NEXT:    movw %ax, 2(%rdi)
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_16f32_to_16i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm1
; AVX512VL-NEXT:    vextractf64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm2, %xmm3
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm3, %xmm4
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm4
; AVX512VL-NEXT:    movw %ax, 24(%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm4
; AVX512VL-NEXT:    movw %ax, 16(%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm4
; AVX512VL-NEXT:    movw %ax, 8(%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm4 = xmm3[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX512VL-NEXT:    movw %ax, (%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm4 = xmm3[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX512VL-NEXT:    movw %ax, 30(%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm4 = xmm0[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm4, %xmm4
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm3 = xmm3[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX512VL-NEXT:    movw %ax, 28(%rdi)
; AVX512VL-NEXT:    vmovd %xmm3, %eax
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm3 = xmm2[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX512VL-NEXT:    movw %ax, 26(%rdi)
; AVX512VL-NEXT:    vmovd %xmm3, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX512VL-NEXT:    movw %ax, 22(%rdi)
; AVX512VL-NEXT:    vmovd %xmm3, %eax
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm3, %xmm3
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm0, %xmm0
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm2[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    movw %ax, 20(%rdi)
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vpermilps {{.*#+}} xmm2 = xmm1[3,1,2,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    movw %ax, 18(%rdi)
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm1[1,1,3,3]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm2, %xmm2
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-NEXT:    vcvtps2ph $4, %xmm1, %xmm1
; AVX512VL-NEXT:    movw %ax, 14(%rdi)
; AVX512VL-NEXT:    vmovd %xmm1, %eax
; AVX512VL-NEXT:    movw %ax, 12(%rdi)
; AVX512VL-NEXT:    vmovd %xmm2, %eax
; AVX512VL-NEXT:    movw %ax, 10(%rdi)
; AVX512VL-NEXT:    vmovd %xmm0, %eax
; AVX512VL-NEXT:    movw %ax, 6(%rdi)
; AVX512VL-NEXT:    vmovd %xmm3, %eax
; AVX512VL-NEXT:    movw %ax, 4(%rdi)
; AVX512VL-NEXT:    vmovd %xmm4, %eax
; AVX512VL-NEXT:    movw %ax, 2(%rdi)
; AVX512VL-NEXT:    retq
  %1 = fptrunc <16 x float> %a0 to <16 x half>
  %2 = bitcast <16 x half> %1 to <16 x i16>
  store <16 x i16> %2, <16 x i16>* %a1
  ret void
}

;
; Double to Half
;

define i16 @cvt_f64_to_i16(double %a0) nounwind {
; ALL-LABEL: cvt_f64_to_i16:
; ALL:       # BB#0:
; ALL-NEXT:    jmp __truncdfhf2 # TAILCALL
  %1 = fptrunc double %a0 to half
  %2 = bitcast half %1 to i16
  ret i16 %2
}

define <2 x i16> @cvt_2f64_to_2i16(<2 x double> %a0) nounwind {
; ALL-LABEL: cvt_2f64_to_2i16:
; ALL:       # BB#0:
; ALL-NEXT:    pushq %rbx
; ALL-NEXT:    subq $16, %rsp
; ALL-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; ALL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; ALL-NEXT:    callq __truncdfhf2
; ALL-NEXT:    movw %ax, %bx
; ALL-NEXT:    shll $16, %ebx
; ALL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; ALL-NEXT:    callq __truncdfhf2
; ALL-NEXT:    movzwl %ax, %eax
; ALL-NEXT:    orl %ebx, %eax
; ALL-NEXT:    vmovd %eax, %xmm0
; ALL-NEXT:    addq $16, %rsp
; ALL-NEXT:    popq %rbx
; ALL-NEXT:    retq
  %1 = fptrunc <2 x double> %a0 to <2 x half>
  %2 = bitcast <2 x half> %1 to <2 x i16>
  ret <2 x i16> %2
}

define <4 x i16> @cvt_4f64_to_4i16(<4 x double> %a0) nounwind {
; AVX1-LABEL: cvt_4f64_to_4i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $40, %rsp
; AVX1-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r14d
; AVX1-NEXT:    orl %ebx, %r14d
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %r14, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    addq $40, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f64_to_4i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $40, %rsp
; AVX2-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r14d
; AVX2-NEXT:    orl %ebx, %r14d
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebx, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %r14, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    addq $40, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f64_to_4i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $40, %rsp
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r14d
; AVX512F-NEXT:    orl %ebx, %r14d
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebx, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %r14, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    addq $40, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f64_to_4i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $40, %rsp
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r14d
; AVX512VL-NEXT:    orl %ebx, %r14d
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebx, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %r14, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    addq $40, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  ret <4 x i16> %2
}

define <8 x i16> @cvt_4f64_to_8i16_undef(<4 x double> %a0) nounwind {
; AVX1-LABEL: cvt_4f64_to_8i16_undef:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $40, %rsp
; AVX1-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r14d
; AVX1-NEXT:    orl %ebx, %r14d
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %r14, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    addq $40, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f64_to_8i16_undef:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $40, %rsp
; AVX2-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r14d
; AVX2-NEXT:    orl %ebx, %r14d
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebx, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %r14, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    addq $40, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f64_to_8i16_undef:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $40, %rsp
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r14d
; AVX512F-NEXT:    orl %ebx, %r14d
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebx, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %r14, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    addq $40, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f64_to_8i16_undef:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $40, %rsp
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r14d
; AVX512VL-NEXT:    orl %ebx, %r14d
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebx, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %r14, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512VL-NEXT:    addq $40, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %3
}

define <8 x i16> @cvt_4f64_to_8i16_zero(<4 x double> %a0) nounwind {
; AVX1-LABEL: cvt_4f64_to_8i16_zero:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $40, %rsp
; AVX1-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r14d
; AVX1-NEXT:    orl %ebx, %r14d
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %r14, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    addq $40, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_4f64_to_8i16_zero:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $40, %rsp
; AVX2-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r14d
; AVX2-NEXT:    orl %ebx, %r14d
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebx, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %r14, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    addq $40, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_4f64_to_8i16_zero:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $40, %rsp
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r14d
; AVX512F-NEXT:    orl %ebx, %r14d
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebx, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %r14, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    addq $40, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_4f64_to_8i16_zero:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $40, %rsp
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r14d
; AVX512VL-NEXT:    orl %ebx, %r14d
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebx, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %r14, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; AVX512VL-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512VL-NEXT:    addq $40, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %3
}

define <8 x i16> @cvt_8f64_to_8i16(<8 x double> %a0) nounwind {
; AVX1-LABEL: cvt_8f64_to_8i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $64, %rsp
; AVX1-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r15d
; AVX1-NEXT:    orl %ebx, %r15d
; AVX1-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r14d
; AVX1-NEXT:    orl %ebx, %r14d
; AVX1-NEXT:    shlq $32, %r14
; AVX1-NEXT:    orq %r15, %r14
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %r15d
; AVX1-NEXT:    orl %ebx, %r15d
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bx
; AVX1-NEXT:    shll $16, %ebx
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %r15, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vmovq %r14, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    addq $64, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    retq
;
; AVX2-LABEL: cvt_8f64_to_8i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $64, %rsp
; AVX2-NEXT:    vmovups %ymm1, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r15d
; AVX2-NEXT:    orl %ebx, %r15d
; AVX2-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r14d
; AVX2-NEXT:    orl %ebx, %r14d
; AVX2-NEXT:    shlq $32, %r14
; AVX2-NEXT:    orq %r15, %r14
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %r15d
; AVX2-NEXT:    orl %ebx, %r15d
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bx
; AVX2-NEXT:    shll $16, %ebx
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebx, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %r15, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vmovq %r14, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    addq $64, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: cvt_8f64_to_8i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %r15
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $96, %rsp
; AVX512F-NEXT:    vmovupd %zmm0, (%rsp) # 64-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r15d
; AVX512F-NEXT:    orl %ebx, %r15d
; AVX512F-NEXT:    vmovupd (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r14d
; AVX512F-NEXT:    orl %ebx, %r14d
; AVX512F-NEXT:    shlq $32, %r14
; AVX512F-NEXT:    orq %r15, %r14
; AVX512F-NEXT:    vmovupd (%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %r15d
; AVX512F-NEXT:    orl %ebx, %r15d
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bx
; AVX512F-NEXT:    shll $16, %ebx
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebx, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %r15, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vmovq %r14, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512F-NEXT:    addq $96, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    popq %r15
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: cvt_8f64_to_8i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %r15
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $96, %rsp
; AVX512VL-NEXT:    vmovupd %zmm0, (%rsp) # 64-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r15d
; AVX512VL-NEXT:    orl %ebx, %r15d
; AVX512VL-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r14d
; AVX512VL-NEXT:    orl %ebx, %r14d
; AVX512VL-NEXT:    shlq $32, %r14
; AVX512VL-NEXT:    orq %r15, %r14
; AVX512VL-NEXT:    vmovupd (%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %r15d
; AVX512VL-NEXT:    orl %ebx, %r15d
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bx
; AVX512VL-NEXT:    shll $16, %ebx
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebx, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %r15, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vmovq %r14, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512VL-NEXT:    addq $96, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    popq %r15
; AVX512VL-NEXT:    retq
  %1 = fptrunc <8 x double> %a0 to <8 x half>
  %2 = bitcast <8 x half> %1 to <8 x i16>
  ret <8 x i16> %2
}

;
; Double to Half (Store)
;

define void @store_cvt_f64_to_i16(double %a0, i16* %a1) nounwind {
; ALL-LABEL: store_cvt_f64_to_i16:
; ALL:       # BB#0:
; ALL-NEXT:    pushq %rbx
; ALL-NEXT:    movq %rdi, %rbx
; ALL-NEXT:    callq __truncdfhf2
; ALL-NEXT:    movw %ax, (%rbx)
; ALL-NEXT:    popq %rbx
; ALL-NEXT:    retq
  %1 = fptrunc double %a0 to half
  %2 = bitcast half %1 to i16
  store i16 %2, i16* %a1
  ret void
}

define void @store_cvt_2f64_to_2i16(<2 x double> %a0, <2 x i16>* %a1) nounwind {
; ALL-LABEL: store_cvt_2f64_to_2i16:
; ALL:       # BB#0:
; ALL-NEXT:    pushq %rbp
; ALL-NEXT:    pushq %rbx
; ALL-NEXT:    subq $24, %rsp
; ALL-NEXT:    movq %rdi, %rbx
; ALL-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; ALL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; ALL-NEXT:    callq __truncdfhf2
; ALL-NEXT:    movl %eax, %ebp
; ALL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; ALL-NEXT:    callq __truncdfhf2
; ALL-NEXT:    movw %ax, (%rbx)
; ALL-NEXT:    movw %bp, 2(%rbx)
; ALL-NEXT:    addq $24, %rsp
; ALL-NEXT:    popq %rbx
; ALL-NEXT:    popq %rbp
; ALL-NEXT:    retq
  %1 = fptrunc <2 x double> %a0 to <2 x half>
  %2 = bitcast <2 x half> %1 to <2 x i16>
  store <2 x i16> %2, <2 x i16>* %a1
  ret void
}

define void @store_cvt_4f64_to_4i16(<4 x double> %a0, <4 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f64_to_4i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $88, %rsp
; AVX1-NEXT:    movq %rdi, %rbx
; AVX1-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r14d
; AVX1-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r15d
; AVX1-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %ebp
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, 4(%rbx)
; AVX1-NEXT:    movw %bp, (%rbx)
; AVX1-NEXT:    movw %r15w, 6(%rbx)
; AVX1-NEXT:    movw %r14w, 2(%rbx)
; AVX1-NEXT:    addq $88, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f64_to_4i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $88, %rsp
; AVX2-NEXT:    movq %rdi, %rbx
; AVX2-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r14d
; AVX2-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r15d
; AVX2-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %ebp
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, 4(%rbx)
; AVX2-NEXT:    movw %bp, (%rbx)
; AVX2-NEXT:    movw %r15w, 6(%rbx)
; AVX2-NEXT:    movw %r14w, 2(%rbx)
; AVX2-NEXT:    addq $88, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f64_to_4i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    pushq %r15
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $88, %rsp
; AVX512F-NEXT:    movq %rdi, %rbx
; AVX512F-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r14d
; AVX512F-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r15d
; AVX512F-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %ebp
; AVX512F-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, 4(%rbx)
; AVX512F-NEXT:    movw %bp, (%rbx)
; AVX512F-NEXT:    movw %r15w, 6(%rbx)
; AVX512F-NEXT:    movw %r14w, 2(%rbx)
; AVX512F-NEXT:    addq $88, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    popq %r15
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f64_to_4i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %rbp
; AVX512VL-NEXT:    pushq %r15
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $88, %rsp
; AVX512VL-NEXT:    movq %rdi, %rbx
; AVX512VL-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r14d
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r15d
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %ebp
; AVX512VL-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, 4(%rbx)
; AVX512VL-NEXT:    movw %bp, (%rbx)
; AVX512VL-NEXT:    movw %r15w, 6(%rbx)
; AVX512VL-NEXT:    movw %r14w, 2(%rbx)
; AVX512VL-NEXT:    addq $88, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    popq %r15
; AVX512VL-NEXT:    popq %rbp
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  store <4 x i16> %2, <4 x i16>* %a1
  ret void
}

define void @store_cvt_4f64_to_8i16_undef(<4 x double> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f64_to_8i16_undef:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $32, %rsp
; AVX1-NEXT:    movq %rdi, %r14
; AVX1-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bp
; AVX1-NEXT:    shll $16, %ebp
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %ebx
; AVX1-NEXT:    orl %ebp, %ebx
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bp
; AVX1-NEXT:    shll $16, %ebp
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebp, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %rbx, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX1-NEXT:    vmovdqa %xmm0, (%r14)
; AVX1-NEXT:    addq $32, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f64_to_8i16_undef:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $32, %rsp
; AVX2-NEXT:    movq %rdi, %r14
; AVX2-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bp
; AVX2-NEXT:    shll $16, %ebp
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %ebx
; AVX2-NEXT:    orl %ebp, %ebx
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bp
; AVX2-NEXT:    shll $16, %ebp
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebp, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %rbx, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX2-NEXT:    vmovdqa %xmm0, (%r14)
; AVX2-NEXT:    addq $32, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f64_to_8i16_undef:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $32, %rsp
; AVX512F-NEXT:    movq %rdi, %r14
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bp
; AVX512F-NEXT:    shll $16, %ebp
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %ebx
; AVX512F-NEXT:    orl %ebp, %ebx
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bp
; AVX512F-NEXT:    shll $16, %ebp
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebp, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %rbx, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15]
; AVX512F-NEXT:    vmovdqa %xmm0, (%r14)
; AVX512F-NEXT:    addq $32, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f64_to_8i16_undef:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %rbp
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $32, %rsp
; AVX512VL-NEXT:    movq %rdi, %r14
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bp
; AVX512VL-NEXT:    shll $16, %ebp
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %ebx
; AVX512VL-NEXT:    orl %ebp, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bp
; AVX512VL-NEXT:    shll $16, %ebp
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebp, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %rbx, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; AVX512VL-NEXT:    vmovdqa32 %xmm0, (%r14)
; AVX512VL-NEXT:    addq $32, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    popq %rbp
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i16> %3, <8 x i16>* %a1
  ret void
}

define void @store_cvt_4f64_to_8i16_zero(<4 x double> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_4f64_to_8i16_zero:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $32, %rsp
; AVX1-NEXT:    movq %rdi, %r14
; AVX1-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bp
; AVX1-NEXT:    shll $16, %ebp
; AVX1-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %ebx
; AVX1-NEXT:    orl %ebp, %ebx
; AVX1-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, %bp
; AVX1-NEXT:    shll $16, %ebp
; AVX1-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movzwl %ax, %eax
; AVX1-NEXT:    orl %ebp, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %rbx, %rax
; AVX1-NEXT:    vmovq %rax, %xmm0
; AVX1-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vmovdqa %xmm0, (%r14)
; AVX1-NEXT:    addq $32, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_4f64_to_8i16_zero:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $32, %rsp
; AVX2-NEXT:    movq %rdi, %r14
; AVX2-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bp
; AVX2-NEXT:    shll $16, %ebp
; AVX2-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %ebx
; AVX2-NEXT:    orl %ebp, %ebx
; AVX2-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, %bp
; AVX2-NEXT:    shll $16, %ebp
; AVX2-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movzwl %ax, %eax
; AVX2-NEXT:    orl %ebp, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    orq %rbx, %rax
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vmovdqa %xmm0, (%r14)
; AVX2-NEXT:    addq $32, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_4f64_to_8i16_zero:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $32, %rsp
; AVX512F-NEXT:    movq %rdi, %r14
; AVX512F-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bp
; AVX512F-NEXT:    shll $16, %ebp
; AVX512F-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %ebx
; AVX512F-NEXT:    orl %ebp, %ebx
; AVX512F-NEXT:    vmovupd (%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, (%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, %bp
; AVX512F-NEXT:    shll $16, %ebp
; AVX512F-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movzwl %ax, %eax
; AVX512F-NEXT:    orl %ebp, %eax
; AVX512F-NEXT:    shlq $32, %rax
; AVX512F-NEXT:    orq %rbx, %rax
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[0,1,4,5,8,9,12,13],zero,zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vmovdqa %xmm0, (%r14)
; AVX512F-NEXT:    addq $32, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_4f64_to_8i16_zero:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %rbp
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $32, %rsp
; AVX512VL-NEXT:    movq %rdi, %r14
; AVX512VL-NEXT:    vmovupd %ymm0, (%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bp
; AVX512VL-NEXT:    shll $16, %ebp
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %ebx
; AVX512VL-NEXT:    orl %ebp, %ebx
; AVX512VL-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, %bp
; AVX512VL-NEXT:    shll $16, %ebp
; AVX512VL-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movzwl %ax, %eax
; AVX512VL-NEXT:    orl %ebp, %eax
; AVX512VL-NEXT:    shlq $32, %rax
; AVX512VL-NEXT:    orq %rbx, %rax
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; AVX512VL-NEXT:    vpshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; AVX512VL-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,1,0,2]
; AVX512VL-NEXT:    vpxord %xmm1, %xmm1, %xmm1
; AVX512VL-NEXT:    vpunpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX512VL-NEXT:    vmovdqa32 %xmm0, (%r14)
; AVX512VL-NEXT:    addq $32, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    popq %rbp
; AVX512VL-NEXT:    retq
  %1 = fptrunc <4 x double> %a0 to <4 x half>
  %2 = bitcast <4 x half> %1 to <4 x i16>
  %3 = shufflevector <4 x i16> %2, <4 x i16> zeroinitializer, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  store <8 x i16> %3, <8 x i16>* %a1
  ret void
}

define void @store_cvt_8f64_to_8i16(<8 x double> %a0, <8 x i16>* %a1) nounwind {
; AVX1-LABEL: store_cvt_8f64_to_8i16:
; AVX1:       # BB#0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %r13
; AVX1-NEXT:    pushq %r12
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    subq $136, %rsp
; AVX1-NEXT:    movq %rdi, %rbx
; AVX1-NEXT:    vmovups %ymm1, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX1-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX1-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX1-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r12d
; AVX1-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX1-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r13d
; AVX1-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %ebp
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r14d
; AVX1-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX1-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movl %eax, %r15d
; AVX1-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX1-NEXT:    callq __truncdfhf2
; AVX1-NEXT:    movw %ax, 12(%rbx)
; AVX1-NEXT:    movw %r15w, 8(%rbx)
; AVX1-NEXT:    movw %r14w, 4(%rbx)
; AVX1-NEXT:    movw %bp, (%rbx)
; AVX1-NEXT:    movw %r13w, 14(%rbx)
; AVX1-NEXT:    movw %r12w, 10(%rbx)
; AVX1-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX1-NEXT:    movw %ax, 6(%rbx)
; AVX1-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX1-NEXT:    movw %ax, 2(%rbx)
; AVX1-NEXT:    addq $136, %rsp
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r12
; AVX1-NEXT:    popq %r13
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: store_cvt_8f64_to_8i16:
; AVX2:       # BB#0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %r13
; AVX2-NEXT:    pushq %r12
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    subq $136, %rsp
; AVX2-NEXT:    movq %rdi, %rbx
; AVX2-NEXT:    vmovups %ymm1, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX2-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX2-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r12d
; AVX2-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX2-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r13d
; AVX2-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %ebp
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r14d
; AVX2-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX2-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movl %eax, %r15d
; AVX2-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX2-NEXT:    callq __truncdfhf2
; AVX2-NEXT:    movw %ax, 12(%rbx)
; AVX2-NEXT:    movw %r15w, 8(%rbx)
; AVX2-NEXT:    movw %r14w, 4(%rbx)
; AVX2-NEXT:    movw %bp, (%rbx)
; AVX2-NEXT:    movw %r13w, 14(%rbx)
; AVX2-NEXT:    movw %r12w, 10(%rbx)
; AVX2-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX2-NEXT:    movw %ax, 6(%rbx)
; AVX2-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX2-NEXT:    movw %ax, 2(%rbx)
; AVX2-NEXT:    addq $136, %rsp
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r12
; AVX2-NEXT:    popq %r13
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: store_cvt_8f64_to_8i16:
; AVX512F:       # BB#0:
; AVX512F-NEXT:    pushq %rbp
; AVX512F-NEXT:    pushq %r15
; AVX512F-NEXT:    pushq %r14
; AVX512F-NEXT:    pushq %r13
; AVX512F-NEXT:    pushq %r12
; AVX512F-NEXT:    pushq %rbx
; AVX512F-NEXT:    subq $200, %rsp
; AVX512F-NEXT:    movq %rdi, %rbx
; AVX512F-NEXT:    vmovupd %zmm0, {{[0-9]+}}(%rsp) # 64-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX512F-NEXT:    vmovupd {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX512F-NEXT:    vmovupd {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; AVX512F-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r12d
; AVX512F-NEXT:    vmovupd {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512F-NEXT:    vmovapd %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512F-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r13d
; AVX512F-NEXT:    vmovups {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %ebp
; AVX512F-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r14d
; AVX512F-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512F-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movl %eax, %r15d
; AVX512F-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512F-NEXT:    callq __truncdfhf2
; AVX512F-NEXT:    movw %ax, 12(%rbx)
; AVX512F-NEXT:    movw %r15w, 8(%rbx)
; AVX512F-NEXT:    movw %r14w, 4(%rbx)
; AVX512F-NEXT:    movw %bp, (%rbx)
; AVX512F-NEXT:    movw %r13w, 14(%rbx)
; AVX512F-NEXT:    movw %r12w, 10(%rbx)
; AVX512F-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX512F-NEXT:    movw %ax, 6(%rbx)
; AVX512F-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX512F-NEXT:    movw %ax, 2(%rbx)
; AVX512F-NEXT:    addq $200, %rsp
; AVX512F-NEXT:    popq %rbx
; AVX512F-NEXT:    popq %r12
; AVX512F-NEXT:    popq %r13
; AVX512F-NEXT:    popq %r14
; AVX512F-NEXT:    popq %r15
; AVX512F-NEXT:    popq %rbp
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: store_cvt_8f64_to_8i16:
; AVX512VL:       # BB#0:
; AVX512VL-NEXT:    pushq %rbp
; AVX512VL-NEXT:    pushq %r15
; AVX512VL-NEXT:    pushq %r14
; AVX512VL-NEXT:    pushq %r13
; AVX512VL-NEXT:    pushq %r12
; AVX512VL-NEXT:    pushq %rbx
; AVX512VL-NEXT:    subq $200, %rsp
; AVX512VL-NEXT:    movq %rdi, %rbx
; AVX512VL-NEXT:    vmovupd %zmm0, {{[0-9]+}}(%rsp) # 64-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, {{[0-9]+}}(%rsp) # 2-byte Spill
; AVX512VL-NEXT:    vmovupd {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; AVX512VL-NEXT:    vmovupd %ymm0, {{[0-9]+}}(%rsp) # 32-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r12d
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    vextractf32x4 $1, %ymm0, %xmm0
; AVX512VL-NEXT:    vmovaps %xmm0, {{[0-9]+}}(%rsp) # 16-byte Spill
; AVX512VL-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r13d
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %zmm0 # 64-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %ZMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %ebp
; AVX512VL-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r14d
; AVX512VL-NEXT:    vmovups {{[0-9]+}}(%rsp), %ymm0 # 32-byte Reload
; AVX512VL-NEXT:    # kill: %XMM0<def> %XMM0<kill> %YMM0<kill>
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movl %eax, %r15d
; AVX512VL-NEXT:    vmovaps {{[0-9]+}}(%rsp), %xmm0 # 16-byte Reload
; AVX512VL-NEXT:    callq __truncdfhf2
; AVX512VL-NEXT:    movw %ax, 12(%rbx)
; AVX512VL-NEXT:    movw %r15w, 8(%rbx)
; AVX512VL-NEXT:    movw %r14w, 4(%rbx)
; AVX512VL-NEXT:    movw %bp, (%rbx)
; AVX512VL-NEXT:    movw %r13w, 14(%rbx)
; AVX512VL-NEXT:    movw %r12w, 10(%rbx)
; AVX512VL-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX512VL-NEXT:    movw %ax, 6(%rbx)
; AVX512VL-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax # 2-byte Folded Reload
; AVX512VL-NEXT:    movw %ax, 2(%rbx)
; AVX512VL-NEXT:    addq $200, %rsp
; AVX512VL-NEXT:    popq %rbx
; AVX512VL-NEXT:    popq %r12
; AVX512VL-NEXT:    popq %r13
; AVX512VL-NEXT:    popq %r14
; AVX512VL-NEXT:    popq %r15
; AVX512VL-NEXT:    popq %rbp
; AVX512VL-NEXT:    retq
  %1 = fptrunc <8 x double> %a0 to <8 x half>
  %2 = bitcast <8 x half> %1 to <8 x i16>
  store <8 x i16> %2, <8 x i16>* %a1
  ret void
}
