//===-- LanaiSelectionDAGInfo.cpp - Lanai SelectionDAG Info -------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file implements the LanaiSelectionDAGInfo class.
//
//===----------------------------------------------------------------------===//

#include "LanaiSelectionDAGInfo.h"

#include "LanaiTargetMachine.h"

#define DEBUG_TYPE "lanai-selectiondag-info"

namespace llvm {

SDValue LanaiSelectionDAGInfo::EmitTargetCodeForMemcpy(
    SelectionDAG &DAG, SDLoc dl, SDValue Chain, SDValue Dst, SDValue Src,
    SDValue Size, unsigned Align, bool isVolatile, bool AlwaysInline,
    MachinePointerInfo DstPtrInfo, MachinePointerInfo SrcPtrInfo) const {
  ConstantSDNode *ConstantSize = dyn_cast<ConstantSDNode>(Size);
  if (!ConstantSize)
    return SDValue();

  return SDValue();
}

} // namespace llvm
