//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <random>

// class seed_seq;

// template<class RandomAccessIterator>
//     void generate(RandomAccessIterator begin, RandomAccessIterator end);

#include <random>
#include <cassert>

int main()
{
    {
        // These numbers generated from a slightly altered version of dSFMT
        //  http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/SFMT/index.html
        unsigned a[] =
        {
            509928861u,
            482551238u,
            141770655u,
            3445468037u,
            1614807826u,
            3110698871u,
            809182926u,
            2644632325u,
            3885131857u,
            1278630374u,
            3648975313u,
            1217833759u,
            1509686260u,
            2817190507u,
            134525747u,
            250267852u,
            2559105345u,
            2416641579u,
            426100435u,
            486929906u,
            241178241u,
            3531539379u,
            704692991u,
            3001633456u,
            3990516671u,
            2619782509u,
            588842726u,
            2871949673u,
            621390331u,
            2304055997u,
            3809702625u,
            2471383485u,
            1630735687u,
            2167939898u,
            2070992669u,
            2826890739u,
            1714346061u,
            1912761420u,
            539780511u,
            716119356u,
            1342493369u,
            1216009367u,
            2864243850u,
            36288867u,
            2981095630u,
            2480586007u,
            1287539180u,
            1804977887u,
            2219960896u,
            297158412u,
            2839013626u,
            1971706101u,
            3588181149u,
            1387242816u,
            3713499635u,
            3408234160u,
            3179393218u,
            1359207226u,
            3119279997u,
            2777679329u,
            125221793u,
            902631799u,
            949389096u,
            3415339313u,
            4117407143u,
            3119227103u,
            1787026946u,
            3917387257u,
            3936044384u,
            2242085379u,
            1140709958u,
            2523265662u,
            3627073995u,
            3604398568u,
            1427913954u,
            2465898599u,
            3825653050u,
            2090876078u,
            232270946u,
            3116274782u,
            1252172657u,
            3197497894u,
            3983224490u,
            1939344836u,
            4158531887u,
            88050086u,
            2343094701u,
            1067025562u,
            3321491106u,
            3772162169u,
            909332669u,
            1671671873u,
            755193996u,
            978524521u,
            2164582730u,
            1757783103u,
            3411415001u,
            850017018u,
            3068762300u,
            555996984u,
            2404040146u,
            3397007611u,
            237680219u,
            245818821u,
            177824968u,
            3220945682u,
            304446762u,
            2267298065u,
            1878973555u,
            3050739800u,
            535731508u,
            1160102565u,
            4109066907u,
            984269821u,
            3681788896u,
            60254699u,
            3890962421u,
            2991673698u,
            3982271427u,
            3514243671u,
            1234870914u,
            2069958363u,
            3867828422u,
            1847469687u,
            503598128u,
            967934988u,
            289386211u,
            393279961u,
            835485527u,
            3708682854u,
            965218590u,
            4020339834u,
            2159101708u,
            2575134771u,
            376656690u,
            3499375240u,
            3105954900u,
            2786692328u,
            3458480699u,
            1207173847u,
            2051152535u,
            2738812911u,
            2954646330u,
            2774866710u,
            2162149150u,
            3993372257u,
            2868120585u,
            3086420190u,
            3791115537u,
            3226697711u,
            1818303409u,
            4206013897u,
            1245186807u,
            1680347447u,
            684800149u,
            2372078492u,
            2566952562u,
            3310947940u,
            3885964747u,
            3270357885u,
            2098965232u,
            609044652u,
            434910954u,
            93043847u,
            805217072u,
            883298424u,
            3850995479u,
            1840717689u,
            124278163u,
            4250050101u,
            2337070911u,
            2576763405u,
            2518189119u,
            3059082421u,
            1532107996u,
            2920167825u,
            2726963926u,
            3951524890u,
            1272835728u,
            1039392592u,
            1237920408u,
            1996153268u,
            647883626u,
            4064365193u,
            355588474u,
            3625797533u,
            1209959194u,
            503163662u,
            530295589u,
            1668578780u,
            969028048u,
            2489337768u,
            841218738u,
            14126306u,
            1854884627u,
            3617055808u,
            202224793u,
            1744552899u,
            1559016256u,
            3455976027u,
            1064269942u,
            2990703287u,
            1169718685u,
            1411804743u,
            290849805u,
            756035681u,
            1505272475u,
            1426658932u,
            16045749u,
            3900455443u,
            108521850u,
            1009491914u,
            3928801938u,
            1022079325u,
            3076867150u,
            4268343543u,
            2886814247u,
            2005055376u,
            1649037732u,
            1954533894u,
            3779223482u,
            1093746989u,
            2376482601u,
            3561720470u,
            1870836501u,
            651953759u,
            1504660027u,
            2097900540u,
            2252668945u,
            2469849023u,
            1986217648u,
            2026387757u,
            131611273u,
            1467981299u,
            3440588252u,
            1916199579u,
            959039804u,
            2895114746u,
            3292235117u,
            649379239u,
            28649189u,
            3121113086u,
            3829761771u,
            1675837301u,
            1636154723u,
            3737794169u,
            4082428060u,
            1904712095u,
            2483810990u,
            979972563u,
            1269082707u,
            370986843u,
            1233170438u,
            3008501783u,
            3905837878u,
            1566704758u,
            2380919351u,
            159980022u,
            1334100319u,
            2492554074u,
            137995234u,
            2318192908u,
            2608964837u,
            1061756617u,
            2760140790u,
            4069446576u,
            1995030350u,
            1037005594u,
            3489306635u,
            1588786838u,
            513304862u,
            3305490303u,
            2264317975u,
            3441620307u,
            4116970950u,
            3121104936u,
            1889858928u,
            2336693483u,
            3906421686u,
            2112501080u,
            2916376262u,
            2244436629u,
            663123276u,
            774309763u,
            258379821u,
            3845948150u,
            3747409682u,
            275936617u,
            563064995u,
            4049677403u,
            2099547498u,
            699768412u,
            1193153383u,
            4289059706u,
            3228950241u,
            1258043728u,
            1334659727u,
            3780523664u,
            1150773584u,
            2509712235u,
            2088544320u,
            1610096547u,
            3486280247u,
            1737969289u,
            1530372860u,
            2563496419u,
            2535243890u,
            998106254u,
            816066803u,
            1138534811u,
            1405672211u,
            2094652173u,
            1516292650u,
            2618233360u,
            3603340340u,
            247950637u,
            119238855u,
            1858201484u,
            3459729922u,
            157759693u,
            8278624u,
            3223944237u,
            3937209237u,
            3820737454u,
            839194830u,
            2385155004u,
            3872251779u,
            1375779033u,
            2333521764u,
            4025446588u,
            3839106064u,
            374878047u,
            1312756310u,
            1661068116u,
            1321601295u,
            4254646350u,
            3813168945u,
            134103711u,
            1535586498u,
            82369644u,
            411323516u,
            761969086u,
            819179215u,
            582595825u,
            3212591411u,
            665647256u,
            2372804634u,
            2378814089u,
            801724318u,
            658137482u,
            2084329677u,
            2512952888u,
            1573871611u,
            570440739u,
            3791634131u,
            1754412850u,
            406040873u,
            2576963615u,
            535767962u,
            1405150444u,
            3050488583u,
            3870648463u,
            2201665400u,
            178518008u,
            1050761986u,
            1635790851u,
            2757604743u,
            1194306620u,
            3895813535u,
            259506203u,
            1836108753u,
            555242075u,
            2574778399u,
            777988603u,
            2306149504u,
            2810362568u,
            402408487u,
            2163697780u,
            1982851065u,
            153191404u,
            1346605886u,
            197579289u,
            3847665347u,
            2437615293u,
            819252195u,
            3379927756u,
            1375088563u,
            2650550959u,
            2949512074u,
            3616578300u,
            1616680753u,
            1943918335u,
            2372676669u,
            599487215u,
            2422499758u,
            3164569986u,
            594265585u,
            667867933u,
            2382753501u,
            1213715652u,
            1470661916u,
            566771851u,
            463440918u,
            3056034602u,
            4101174909u,
            130576467u,
            2390765932u,
            1878895359u,
            2047260663u,
            3236801323u,
            1417182786u,
            2650291174u,
            541535507u,
            2050658788u,
            1497955566u,
            2322165653u,
            2177087336u,
            1286897331u,
            1168276780u,
            2296212785u,
            865258239u,
            1996766009u,
            2012854679u,
            1601388981u,
            2613134235u,
            1657591526u,
            2928355430u,
            3608354462u,
            744304148u,
            4205438799u,
            3436255438u,
            2852837451u,
            3546154475u,
            2198801660u,
            2941229067u,
            1725744406u,
            1576016233u,
            326273484u,
            3350602572u,
            2525026956u,
            529269391u,
            742537386u,
            966948684u,
            4207482684u,
            1647708147u,
            772473614u,
            4100132656u,
            2071821864u,
            1304991378u,
            2104686786u,
            494532571u,
            1596637043u,
            3530310572u,
            3844404338u,
            311529967u,
            2146085784u,
            1023590767u,
            3264294551u,
            1868912500u,
            1616049700u,
            4044971489u,
            226083499u,
            2644402452u,
            671262u,
            3856282165u,
            2788249556u,
            2975877350u,
            3022011519u,
            482463024u,
            3197313892u,
            2458947070u,
            213085732u,
            3423982376u,
            1127434251u,
            3003351323u,
            3859782824u,
            1452447943u,
            1377205388u,
            294467710u,
            4017757977u,
            4176004933u,
            1973840971u,
            1057204069u,
            2631053578u,
            1518315828u,
            1733084351u,
            2897935365u,
            371135589u,
            2166429075u,
            1316999184u,
            917942378u,
            4234919037u,
            3994887147u,
            202839671u,
            2611806597u,
            1763402132u,
            2528354843u,
            2928374144u,
            4287461088u,
            3374274817u,
            2515840515u,
            1174711579u,
            1526125414u,
            1328334421u,
            1467789564u,
            746112865u,
            2522923249u,
            2846786366u,
            785624778u,
            3640382502u,
            699425627u,
            2333340032u,
            879149811u,
            1012137370u,
            3671295088u,
            1115225691u,
            2008076767u,
            3224593008u,
            409074767u,
            3405081375u,
            1732184447u,
            4131742042u,
            2887579728u,
            411122719u,
            49575303u,
            2452487329u,
            132404436u,
            2634269867u,
            628865612u,
            2089064207u,
            3493619675u,
            573570698u,
            2803401952u,
            1846326706u,
            2776480783u,
            3202282367u,
            161406647u,
            555882857u,
            3002347158u,
            3646590134u,
            3970439001u,
            3593229755u,
            589030935u,
            1156189491u,
            4233262968u,
            1884160487u,
            1538393768u,
            2259575756u,
            1419917258u,
            658738179u,
            2762821193u,
            3753817926u,
            760570680u,
            900223123u,
            3199204483u,
            3152387802u,
            3518662321u,
            1138026800u,
            4166103824u,
            4256962887u,
            3860671603u,
            2476911454u,
            336216996u,
            708885235u,
            725397672u,
            1803116762u,
            2785555576u,
            101740015u,
            4078718445u,
            1955237214u,
            9650972u,
            449296169u,
            584729435u,
            3295180521u,
            589654348u,
            4256205129u,
            3872811168u,
            1159848257u,
            3914402308u,
            739056677u,
            2654817235u,
            2975781832u,
            2945335776u,
            2792662538u,
            4124362519u,
            1578034244u,
            347127450u,
            818851140u,
            2127100315u,
            2486499071u,
            4198130806u,
            1869105609u,
            1961961717u,
            1651285423u,
            376774848u,
            2681263019u,
            1185959234u,
            1674813864u,
            32812913u,
            3511671436u,
            3250344299u,
            2961919237u,
            722029715u,
            3677835234u,
            3534013806u,
            2896926420u,
            2405611392u,
            1523923100u,
            538451356u,
            2872548905u,
            3122230170u,
            337087364u,
            2659340735u,
            3849128055u,
            556114376u,
            1997152544u,
            3761450839u,
            3143779940u,
            3256759779u,
            2844565122u,
            228442897u,
            3589092287u,
            786119294u,
            4089515771u,
            3720982051u,
            1236422652u,
            2002271241u,
            98809947u,
            1925281885u,
            3856119646u,
            3522402037u,
            2119723860u,
            3500067577u,
            3688915105u,
            443441159u,
            1795715271u,
            2772968214u,
            921416086u,
            4274010930u,
            3123194886u,
            4156595625u,
            2153773382u,
            1880645824u,
            1783695477u,
            2639075904u,
            2369609874u,
            2020298024u,
            3035677150u,
            20152938u,
            3700162244u,
            2301383878u,
            704787941u,
            1912605772u,
            801557569u,
            3080244537u,
            2116665331u,
            2452111071u,
            3506260614u,
            862540580u,
            1275699972u,
            66210903u,
            106773917u,
            3693457478u,
            2402783622u,
            1239121180u,
            676003037u,
            2603048829u,
            1725001637u,
            1220274379u,
            24507488u,
            903764486u,
            4189545897u,
            1702746631u,
            3218068652u,
            3306659191u,
            790973134u,
            1265526960u,
            3431804268u,
            3325211765u,
            3605213000u,
            2877687268u,
            2252987926u,
            2380945092u,
            858624424u,
            1002964636u,
            1862801950u,
            1624111941u,
            2506763607u,
            760658520u,
            2734479345u,
            3411969548u,
            771362694u,
            3655222003u,
            2713412965u,
            2617767046u,
            1779451182u,
            3696950253u,
            1494085808u,
            1423735456u,
            800705781u,
            3797847307u,
            3518984231u,
            196474988u,
            1813335502u,
            2243046583u,
            2578707704u,
            2592488572u,
            4085007200u,
            3609770110u,
            2731535571u,
            3190540952u,
            1865257805u,
            1804143221u,
            3166875197u,
            1184225570u,
            2013135819u,
            3678444101u,
            2569887572u,
            3559018477u,
            3823772506u,
            1537738480u,
            713705243u,
            792081862u,
            1581340885u,
            3140030205u,
            3435723625u,
            3093218524u,
            3683643763u,
            753869336u,
            590258834u,
            608176704u,
            180732483u,
            31365344u,
            29753898u,
            2899243456u,
            1020423361u,
            152655309u,
            3809554076u,
            2069071231u,
            4000441303u,
            3046501174u,
            1897816893u,
            1610689080u,
            2580357110u,
            255270539u,
            3363490012u,
            3711397066u,
            3983751767u,
            1725231855u,
            172296475u,
            2179003295u,
            660196982u,
            526538193u,
            2137670317u,
            2219075701u,
            1987239722u,
            856404486u,
            2976933454u,
            3678014122u,
            2713682703u,
            3329090001u,
            2248358519u,
            3254616418u,
            1747030903u,
            1620566606u,
            880370315u,
            2337236788u,
            2883145755u
        };
        const int n = 768;
        unsigned b[n] = {0};
        unsigned v[] = {3, 5, 7};
        const int size = sizeof(v)/sizeof(v[0]);
        std::seed_seq s(v, v + size);
        s.generate(b, b + n);
        for (int i = 0; i < n; ++i)
            assert(a[i] == b[i]);
    }
}
